/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.proxy;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.smallmind.web.jersey.proxy.ExtraLaxRedirectStrategy;
import org.smallmind.web.jersey.proxy.HttpProtocol;
import org.smallmind.web.jersey.proxy.JsonTarget;
import org.smallmind.web.jersey.proxy.TrustAllHostNameVerifier;

public class JsonTargetFactory {
    public static JsonTarget manufacture(String host, int concurrencyLevel) throws NoSuchAlgorithmException, MalformedURLException, URISyntaxException, KeyStoreException, KeyManagementException {
        return JsonTargetFactory.manufacture(HttpProtocol.HTTP, host, 0, null, concurrencyLevel);
    }

    public static JsonTarget manufacture(HttpProtocol protocol, String host, int concurrencyLevel) throws NoSuchAlgorithmException, MalformedURLException, URISyntaxException, KeyStoreException, KeyManagementException {
        return JsonTargetFactory.manufacture(protocol, host, 0, null, concurrencyLevel);
    }

    public static JsonTarget manufacture(HttpProtocol protocol, String host, int port, int concurrencyLevel) throws NoSuchAlgorithmException, MalformedURLException, URISyntaxException, KeyStoreException, KeyManagementException {
        return JsonTargetFactory.manufacture(protocol, host, port, null, concurrencyLevel);
    }

    public static JsonTarget manufacture(HttpProtocol protocol, String host, String context, int concurrencyLevel) throws NoSuchAlgorithmException, MalformedURLException, URISyntaxException, KeyStoreException, KeyManagementException {
        return JsonTargetFactory.manufacture(protocol, host, 0, context, concurrencyLevel);
    }

    public static JsonTarget manufacture(HttpProtocol protocol, String host, int port, String context, int concurrencyLevel) throws NoSuchAlgorithmException, MalformedURLException, URISyntaxException, KeyStoreException, KeyManagementException {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).build();
        clientBuilder.setSSLContext(sslContext);
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new TrustAllHostNameVerifier());
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connectionManager.setDefaultConnectionConfig(ConnectionConfig.custom().setCharset(StandardCharsets.UTF_8).build());
        connectionManager.setDefaultSocketConfig(SocketConfig.copy((SocketConfig)SocketConfig.DEFAULT).setSoTimeout(20000).setTcpNoDelay(true).build());
        connectionManager.setDefaultMaxPerRoute(concurrencyLevel);
        connectionManager.setMaxTotal(concurrencyLevel);
        CloseableHttpClient httpClient = clientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager).setRedirectStrategy((RedirectStrategy)new ExtraLaxRedirectStrategy()).build();
        return new JsonTarget(httpClient, URI.create(String.valueOf(protocol.getScheme()) + "://" + host + (port > 0 ? ":" + port : "") + (context != null ? context : "")));
    }
}

