/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.persistence.hibernate;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.TextType;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.smallmind.nutsnbolts.json.VersionedJson;
import org.smallmind.nutsnbolts.version.Version;
import org.smallmind.nutsnbolts.version.VersionFactory;
import org.smallmind.web.jersey.util.JsonCodec;

public class VersionedJsonUserType<V extends Version<V>>
implements UserType,
ParameterizedType {
    private VersionFactory<V> versionFactory;

    public void setParameterValues(Properties parameters) {
        String versionFactoryClassName = parameters.getProperty("versionFactoryClassName");
        try {
            Class<?> versionFactoryClass = Class.forName(versionFactoryClassName);
            this.versionFactory = (VersionFactory)versionFactoryClass.newInstance();
        }
        catch (Exception exception) {
            throw new HibernateException((Throwable)exception);
        }
    }

    public boolean isMutable() {
        return false;
    }

    public Class returnedClass() {
        return VersionedJson.class;
    }

    public int[] sqlTypes() {
        return new int[]{12, TextType.INSTANCE.sqlType()};
    }

    public Object assemble(Serializable cached, Object owner) {
        return cached;
    }

    public Serializable disassemble(Object value) {
        return (Serializable)value;
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public Object replace(Object original, Object target, Object owner) {
        return original;
    }

    public boolean equals(Object x, Object y) {
        return x == y || x != null && x.equals(y);
    }

    public int hashCode(Object x) {
        return x == null ? 0 : x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        String versionAsString = rs.getString(names[0]);
        if (versionAsString != null) {
            Version version = this.versionFactory.fromString(versionAsString);
            String jsonAsString = rs.getString(names[1]);
            if (jsonAsString != null) {
                try {
                    return JsonCodec.read(jsonAsString, version.getVersionedClass());
                }
                catch (IOException ioException) {
                    throw new HibernateException((Throwable)ioException);
                }
            }
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 12);
            st.setNull(index + 1, TextType.INSTANCE.sqlType());
        } else {
            st.setString(index, ((VersionedJson)value).getVersion().toString());
            try {
                st.setString(index + 1, JsonCodec.writeAsString(value));
            }
            catch (JsonProcessingException jsonProcessingException) {
                throw new HibernateException((Throwable)jsonProcessingException);
            }
        }
    }
}

