/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.fault;

import java.io.IOException;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.smallmind.scribe.pen.LoggerManager;
import org.smallmind.web.jersey.fault.FaultElement;
import org.smallmind.web.jersey.fault.NativeObject;
import org.smallmind.web.jersey.util.JsonCodec;

@XmlRootElement(name="fault")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class Fault
implements Serializable {
    private Fault cause;
    private FaultElement context;
    private FaultElement[] elements;
    private Object information;
    private String throwableType;
    private String message;
    private NativeObject nativeObject;

    public Fault() {
    }

    public Fault(String message) {
        this.message = message;
    }

    public Fault(FaultElement context, String message) {
        this(message);
        this.context = context;
    }

    public Fault(Throwable throwable) {
        this(null, throwable, true);
    }

    public Fault(FaultElement context, Throwable throwable) {
        this(context, throwable, true);
    }

    public Fault(Throwable throwable, boolean includeNativeEncoding) {
        this(null, throwable, includeNativeEncoding);
    }

    public Fault(FaultElement context, Throwable throwable, boolean includeNativeEncoding) {
        this.context = context;
        int index = 0;
        if (includeNativeEncoding) {
            try {
                this.nativeObject = new NativeObject(throwable);
            }
            catch (IOException ioException) {
                LoggerManager.getLogger(Fault.class).error((Throwable)ioException);
            }
        }
        this.throwableType = throwable.getClass().getName();
        this.message = throwable.getMessage();
        StackTraceElement[] stackTraceElements = throwable.getStackTrace();
        if (stackTraceElements != null) {
            this.elements = new FaultElement[stackTraceElements.length];
            StackTraceElement[] stackTraceElementArray = stackTraceElements;
            int n = stackTraceElements.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                this.elements[index++] = new FaultElement(stackTraceElement);
                ++n2;
            }
        }
        if (throwable.getCause() != null) {
            this.cause = new Fault(throwable.getCause());
        }
    }

    private static int findRepeatedStackElements(FaultElement element, FaultElement[] prevTrace) {
        int count = 0;
        while (count < prevTrace.length) {
            if (element.equals(prevTrace[count])) {
                return prevTrace.length - count;
            }
            ++count;
        }
        return -1;
    }

    @XmlElementRef(name="context", required=false)
    public FaultElement getContext() {
        return this.context;
    }

    public void setContext(FaultElement context) {
        this.context = context;
    }

    @XmlElement(name="type")
    public String getThrowableType() {
        return this.throwableType;
    }

    public void setThrowableType(String throwableType) {
        this.throwableType = throwableType;
    }

    @XmlElement(name="message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @XmlElementRef(name="cause", required=false)
    public Fault getCause() {
        return this.cause;
    }

    public void setCause(Fault cause) {
        this.cause = cause;
    }

    @XmlElement(name="trace")
    public FaultElement[] getElements() {
        return this.elements;
    }

    public void setElements(FaultElement[] elements) {
        this.elements = elements;
    }

    @XmlTransient
    public <T> T getInformationAs(Class<T> clazz) {
        return this.information == null ? null : (T)JsonCodec.convert(this.information, clazz);
    }

    @XmlElementRef(name="information")
    @XmlAnyElement
    public Object getInformation() {
        return this.information;
    }

    public Fault setInformation(Object information) {
        this.information = information;
        return this;
    }

    @XmlElementRef(name="native", required=false)
    public NativeObject getNativeObject() {
        return this.nativeObject;
    }

    public void setNativeObject(NativeObject nativeObject) {
        this.nativeObject = nativeObject;
    }

    public String toString() {
        StringBuilder lineBuilder = new StringBuilder("Error in process ");
        if (this.context != null) {
            lineBuilder.append("at ").append(this.context).append(' ');
        }
        return this.print(lineBuilder);
    }

    private String print(StringBuilder lineBuilder) {
        Fault fault = this;
        FaultElement[] prevTrace = null;
        StringBuilder traceBuilder = new StringBuilder();
        do {
            String throwableType;
            if (prevTrace != null) {
                lineBuilder.append("Caused by: ");
            }
            lineBuilder.append((throwableType = fault.getThrowableType()) != null ? throwableType : "unknown");
            lineBuilder.append(": ");
            lineBuilder.append(fault.getMessage());
            traceBuilder.append((CharSequence)lineBuilder).append(System.getProperty("line.separator"));
            lineBuilder.delete(0, lineBuilder.length());
            if (fault.getElements() != null) {
                FaultElement[] faultElementArray = fault.getElements();
                int n = faultElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int repeatedElements;
                    FaultElement element = faultElementArray[n2];
                    if (prevTrace != null && (repeatedElements = Fault.findRepeatedStackElements(element, prevTrace)) >= 0) {
                        lineBuilder.append("   ... ");
                        lineBuilder.append(repeatedElements);
                        lineBuilder.append(" more");
                        traceBuilder.append((CharSequence)lineBuilder).append(System.getProperty("line.separator"));
                        lineBuilder.delete(0, lineBuilder.length());
                        break;
                    }
                    lineBuilder.append("   at ");
                    lineBuilder.append(element);
                    traceBuilder.append((CharSequence)lineBuilder).append(System.getProperty("line.separator"));
                    lineBuilder.delete(0, lineBuilder.length());
                    ++n2;
                }
            }
            prevTrace = fault.getElements();
        } while ((fault = fault.getCause()) != null);
        return traceBuilder.toString();
    }
}

