/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Path;
import org.apache.http.HttpEntity;
import org.smallmind.web.jersey.aop.EntityParam;
import org.smallmind.web.jersey.proxy.Argument;
import org.smallmind.web.jersey.proxy.Envelope;
import org.smallmind.web.jersey.proxy.JsonHttpEntity;
import org.smallmind.web.jersey.proxy.JsonTarget;
import org.smallmind.web.jersey.proxy.ResourceDefinitionException;

public class JsonEntityInvocationHandler
implements InvocationHandler {
    private final ConcurrentHashMap<Method, String[]> parameterNameMap = new ConcurrentHashMap();
    private final JsonTarget target;
    private final String serviceName;
    private final String basePath;
    private final int serviceVersion;

    public JsonEntityInvocationHandler(JsonTarget target, int serviceVersion, String serviceName) {
        this.target = target;
        this.serviceVersion = serviceVersion;
        this.serviceName = serviceName;
        this.basePath = "/v" + serviceVersion + '/' + serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Path pathAnnotation = method.getAnnotation(Path.class);
        String[] argumentNames = this.parameterNameMap.get(method);
        if (argumentNames == null) {
            ConcurrentHashMap<Method, String[]> concurrentHashMap = this.parameterNameMap;
            synchronized (concurrentHashMap) {
                argumentNames = this.parameterNameMap.get(method);
                if (argumentNames == null) {
                    argumentNames = this.constructArgumentNames(method);
                    this.parameterNameMap.put(method, argumentNames);
                }
            }
        }
        Argument[] arguments = new Argument[args.length];
        int index = 0;
        while (index < args.length) {
            arguments[index] = new Argument(argumentNames[index], args[index]);
            ++index;
        }
        return this.target.path(String.valueOf(this.basePath) + (pathAnnotation != null ? pathAnnotation.value() : String.valueOf('/') + method.getName())).post((HttpEntity)new JsonHttpEntity(new Envelope(arguments)), method.getReturnType());
    }

    private String[] constructArgumentNames(Method method) throws ResourceDefinitionException {
        String[] argumentNames = new String[method.getParameterTypes().length];
        int index = 0;
        Annotation[][] annotationArray = method.getParameterAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation[] parameterAnnotations;
            Annotation[] annotationArray2 = parameterAnnotations = annotationArray[n2];
            int n3 = parameterAnnotations.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation annotation = annotationArray2[n4];
                if (annotation.annotationType().equals(EntityParam.class)) {
                    argumentNames[index++] = ((EntityParam)annotation).value();
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (index != argumentNames.length) {
            throw new ResourceDefinitionException("The method(%s) of resource interface(%s) version(%d) requires @EntityParameter annotations", method.getName(), this.serviceName, this.serviceVersion);
        }
        return argumentNames;
    }
}

