/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.WebApplicationException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.smallmind.nutsnbolts.http.HttpMethod;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.nutsnbolts.util.Pair;
import org.smallmind.nutsnbolts.util.Tuple;
import org.smallmind.web.jersey.proxy.QuotedInputStream;
import org.smallmind.web.jersey.util.JsonCodec;

public class JsonTarget {
    private final CloseableHttpClient httpClient;
    private final URI uri;
    private Tuple<String, String> headers;
    private Tuple<String, String> queryParameters;

    public JsonTarget(CloseableHttpClient httpClient, URI uri) {
        this.httpClient = httpClient;
        this.uri = uri;
    }

    public JsonTarget path(String path) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder().setScheme(this.uri.getScheme()).setUserInfo(this.uri.getUserInfo()).setHost(this.uri.getHost()).setPort(this.uri.getPort()).setPath(this.uri.getPath()).setCustomQuery(this.uri.getQuery()).setFragment(this.uri.getFragment());
        URI pathURI = URI.create(path);
        if (pathURI.getScheme() != null) {
            uriBuilder.setScheme(pathURI.getScheme());
        }
        if (pathURI.getUserInfo() != null) {
            uriBuilder.setUserInfo(pathURI.getUserInfo());
        }
        if (pathURI.getHost() != null) {
            uriBuilder.setHost(pathURI.getHost());
        }
        if (pathURI.getPort() > 0) {
            uriBuilder.setPort(pathURI.getPort());
        }
        if (pathURI.getPath() != null) {
            uriBuilder.setPath(this.uri.getPath() == null ? pathURI.getPath() : String.valueOf(this.uri.getPath()) + pathURI.getPath());
        }
        if (pathURI.getRawQuery() != null) {
            uriBuilder.setCustomQuery(this.uri.getRawQuery() == null ? pathURI.getQuery() : String.valueOf(this.uri.getQuery()) + "&" + pathURI.getQuery());
        }
        if (pathURI.getFragment() != null) {
            uriBuilder.setFragment(pathURI.getFragment());
        }
        return new JsonTarget(this.httpClient, uriBuilder.build());
    }

    public JsonTarget header(String key, String value) {
        if (this.headers == null) {
            this.headers = new Tuple();
        }
        this.headers.addPair((Object)key, (Object)value);
        return this;
    }

    public JsonTarget query(String key, String value) {
        if (this.queryParameters == null) {
            this.queryParameters = new Tuple();
        }
        this.queryParameters.addPair((Object)key, (Object)value);
        return this;
    }

    public <T> T get(Class<T> responseClass) throws IOException, URISyntaxException {
        HttpGet httpGet = (HttpGet)this.createHttpRequest(HttpMethod.GET, null);
        Throwable throwable = null;
        Object var4_5 = null;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            return this.convertEntity((HttpResponse)response, responseClass);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public <T> T put(HttpEntity entity, Class<T> responseClass) throws IOException, URISyntaxException {
        HttpPut httpPut = (HttpPut)this.createHttpRequest(HttpMethod.PUT, entity);
        httpPut.setEntity(entity);
        Throwable throwable = null;
        Object var5_6 = null;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPut);){
            return this.convertEntity((HttpResponse)response, responseClass);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public <T> T post(HttpEntity entity, Class<T> responseClass) throws IOException, URISyntaxException {
        HttpPost httpPost = (HttpPost)this.createHttpRequest(HttpMethod.POST, entity);
        httpPost.setEntity(entity);
        Throwable throwable = null;
        Object var5_6 = null;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            return this.convertEntity((HttpResponse)response, responseClass);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public <T> T patch(HttpEntity entity, Class<T> responseClass) throws IOException, URISyntaxException {
        HttpPatch httpPatch = (HttpPatch)this.createHttpRequest(HttpMethod.PATCH, entity);
        httpPatch.setEntity(entity);
        Throwable throwable = null;
        Object var5_6 = null;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPatch);){
            return this.convertEntity((HttpResponse)response, responseClass);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public <T> T delete(Class<T> responseClass) throws IOException, URISyntaxException {
        HttpDelete httpDelete = (HttpDelete)this.createHttpRequest(HttpMethod.DELETE, null);
        Throwable throwable = null;
        Object var4_5 = null;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpDelete);){
            return this.convertEntity((HttpResponse)response, responseClass);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private <T> T convertEntity(HttpResponse response, Class<T> responseClass) throws IOException {
        InputStream entityInputStream;
        HttpEntity entity = response.getEntity();
        if (entity == null || entity.getContentLength() == 0L || (entityInputStream = entity.getContent()) == null) {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine == null || statusLine.getStatusCode() >= 200 && statusLine.getStatusCode() < 300) {
                return null;
            }
            throw new WebApplicationException(statusLine.getReasonPhrase(), statusLine.getStatusCode());
        }
        return JsonCodec.read(String.class.equals(responseClass) ? new QuotedInputStream(entityInputStream) : entityInputStream, responseClass);
    }

    private HttpRequest createHttpRequest(HttpMethod httpMethod, HttpEntity entity) throws URISyntaxException {
        Header contentTypeHeader;
        HttpGet httpRequest;
        block19: {
            block18: {
                if (this.queryParameters != null) break block18;
                switch (httpMethod) {
                    case GET: {
                        httpRequest = new HttpGet(this.uri);
                        break block19;
                    }
                    case PUT: {
                        httpRequest = new HttpPut(this.uri);
                        break block19;
                    }
                    case POST: {
                        httpRequest = new HttpPost(this.uri);
                        break block19;
                    }
                    case PATCH: {
                        httpRequest = new HttpPatch(this.uri);
                        break block19;
                    }
                    case DELETE: {
                        httpRequest = new HttpDelete(this.uri);
                        break block19;
                    }
                    default: {
                        throw new UnknownSwitchCaseException(httpMethod.name(), new Object[0]);
                    }
                }
            }
            URIBuilder uriBuilder = new URIBuilder(this.uri);
            for (Pair queryPair : this.queryParameters) {
                uriBuilder.addParameter((String)queryPair.getFirst(), (String)queryPair.getSecond());
            }
            switch (httpMethod) {
                case GET: {
                    httpRequest = new HttpGet(uriBuilder.build());
                    break;
                }
                case PUT: {
                    httpRequest = new HttpPut(uriBuilder.build());
                    break;
                }
                case POST: {
                    httpRequest = new HttpPost(uriBuilder.build());
                    break;
                }
                case PATCH: {
                    httpRequest = new HttpPatch(uriBuilder.build());
                    break;
                }
                case DELETE: {
                    httpRequest = new HttpDelete(uriBuilder.build());
                    break;
                }
                default: {
                    throw new UnknownSwitchCaseException(httpMethod.name(), new Object[0]);
                }
            }
        }
        if (this.headers != null) {
            for (Pair headerPair : this.headers) {
                httpRequest.addHeader((String)headerPair.getFirst(), (String)headerPair.getSecond());
            }
        }
        if (entity != null && (contentTypeHeader = entity.getContentType()) != null) {
            httpRequest.setHeader(contentTypeHeader.getName(), contentTypeHeader.getValue());
        }
        return httpRequest;
    }
}

