/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.reflection;

import java.io.IOException;
import java.util.LinkedList;
import org.smallmind.nutsnbolts.reflection.bean.BeanAccessException;
import org.smallmind.web.jersey.reflection.PathComponent;

public class ComponentParser {
    public static PathComponent[] parse(String methodChain) throws BeanAccessException {
        LinkedList<PathComponent> componentList = new LinkedList<PathComponent>();
        if (methodChain != null) {
            PathComponent component = null;
            State state = State.START_COMPONENT;
            int mark = -1;
            int index = 0;
            while (index < methodChain.length()) {
                switch (state) {
                    case START_COMPONENT: {
                        if (component != null) {
                            componentList.add(component);
                            component = null;
                        }
                        if (!Character.isWhitespace(methodChain.charAt(index))) {
                            state = State.START_METHOD_NAME;
                            break;
                        }
                        ++index;
                        break;
                    }
                    case START_METHOD_NAME: {
                        if (!Character.isJavaIdentifierStart(methodChain.charAt(index))) {
                            throw new BeanAccessException("Illegal java identifier at index(%d) in method chain(%s)", new Object[]{index, methodChain});
                        }
                        mark = index++;
                        state = State.METHOD_NAME;
                        break;
                    }
                    case METHOD_NAME: {
                        switch (methodChain.charAt(index)) {
                            case '.': {
                                state = State.START_COMPONENT;
                                component = new PathComponent(methodChain.substring(mark, index));
                                break;
                            }
                            case '(': {
                                state = State.START_PARAMETERS;
                                component = new PathComponent(methodChain.substring(mark, index));
                                break;
                            }
                            case '[': {
                                state = State.START_SUBSCRIPT;
                                component = new PathComponent(methodChain.substring(mark, index));
                                break;
                            }
                            default: {
                                if (Character.isWhitespace(methodChain.charAt(index))) {
                                    state = State.END_METHOD_NAME;
                                    component = new PathComponent(methodChain.substring(mark, index));
                                    break;
                                }
                                if (Character.isJavaIdentifierPart(methodChain.charAt(index))) break;
                                throw new BeanAccessException("Illegal java identifier at index(%d) in method chain(%s)", new Object[]{index, methodChain});
                            }
                        }
                        ++index;
                        break;
                    }
                    case END_METHOD_NAME: {
                        switch (methodChain.charAt(index)) {
                            case '.': {
                                state = State.START_COMPONENT;
                                break;
                            }
                            case '(': {
                                state = State.START_PARAMETERS;
                                break;
                            }
                            case '[': {
                                state = State.START_SUBSCRIPT;
                                break;
                            }
                            default: {
                                if (Character.isWhitespace(methodChain.charAt(index))) break;
                                throw new BeanAccessException("Illegal java identifier at index(%d) in method chain(%s)", new Object[]{index, methodChain});
                            }
                        }
                        ++index;
                        break;
                    }
                    case START_PARAMETERS: {
                        mark = index;
                        state = State.PARAMETERS;
                        break;
                    }
                    case PARAMETERS: {
                        switch (methodChain.charAt(index)) {
                            case '\"': {
                                state = State.STRING;
                                break;
                            }
                            case ')': {
                                try {
                                    component.createArguments(methodChain.substring(mark, index));
                                }
                                catch (IOException iOException) {
                                    throw new BeanAccessException("Illegal parameter arguments at index(%d) in method chain(%s)", new Object[]{index, methodChain});
                                }
                                state = State.END_PARAMETERS;
                            }
                        }
                        ++index;
                        break;
                    }
                    case STRING: {
                        switch (methodChain.charAt(index)) {
                            case '\\': {
                                state = State.ESCAPE;
                                break;
                            }
                            case '\"': {
                                state = State.PARAMETERS;
                            }
                        }
                        ++index;
                        break;
                    }
                    case ESCAPE: {
                        state = State.STRING;
                        ++index;
                        break;
                    }
                    case END_PARAMETERS: {
                        switch (methodChain.charAt(index)) {
                            case '.': {
                                state = State.START_COMPONENT;
                                break;
                            }
                            case '[': {
                                state = State.START_SUBSCRIPT;
                                break;
                            }
                            default: {
                                if (Character.isWhitespace(methodChain.charAt(index))) break;
                                throw new BeanAccessException("Illegal java identifier at index(%d) in method chain(%s)", new Object[]{index, methodChain});
                            }
                        }
                        ++index;
                        break;
                    }
                    case START_SUBSCRIPT: {
                        if (Character.isDigit(methodChain.charAt(index))) {
                            mark = index;
                            state = State.SUBSCRIPT;
                        } else if (!Character.isWhitespace(methodChain.charAt(index))) {
                            throw new BeanAccessException("Illegal subscript at index(%d) in method chain(%s)", new Object[]{index, methodChain});
                        }
                        ++index;
                        break;
                    }
                    case SUBSCRIPT: {
                        if (methodChain.charAt(index) == ']') {
                            try {
                                component.addSubscript(methodChain.substring(mark, index));
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new BeanAccessException("Illegal subscript at index(%d) in method chain(%s)", new Object[]{mark, methodChain});
                            }
                            state = State.END_PARAMETERS;
                        }
                        ++index;
                    }
                }
            }
            switch (state) {
                case START_COMPONENT: {
                    if (componentList.isEmpty()) {
                        throw new BeanAccessException("Empty method chain", new Object[]{methodChain});
                    }
                    throw new BeanAccessException("Missing termination in method chain(%s)", new Object[]{methodChain});
                }
                case METHOD_NAME: {
                    componentList.add(new PathComponent(methodChain.substring(mark, index)));
                    break;
                }
                case END_METHOD_NAME: {
                    componentList.add(component);
                    break;
                }
                case END_PARAMETERS: {
                    componentList.add(component);
                    break;
                }
                default: {
                    throw new BeanAccessException("Missing termination in method chain(%s)", new Object[]{methodChain});
                }
            }
        }
        PathComponent[] components = new PathComponent[componentList.size()];
        componentList.toArray(components);
        return components;
    }

    private static enum State {
        START_COMPONENT,
        START_METHOD_NAME,
        METHOD_NAME,
        END_METHOD_NAME,
        START_PARAMETERS,
        PARAMETERS,
        STRING,
        ESCAPE,
        END_PARAMETERS,
        START_SUBSCRIPT,
        SUBSCRIPT;

    }
}

