/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.reflection;

import java.io.IOException;
import java.util.LinkedList;
import org.smallmind.web.jersey.util.JsonCodec;

public class PathComponent {
    private LinkedList<Integer> subscriptList;
    private Object[] arguments;
    private String name;

    public PathComponent(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void createArguments(String argumentSubPath) throws IOException {
        this.arguments = JsonCodec.read(String.valueOf('[') + argumentSubPath.trim() + ']', Object[].class);
    }

    public int[] getSubscripts() {
        if (this.subscriptList == null || this.subscriptList.isEmpty()) {
            return null;
        }
        int[] subscripts = new int[this.subscriptList.size()];
        int index = 0;
        for (Integer subscript : this.subscriptList) {
            subscripts[index++] = subscript;
        }
        return subscripts;
    }

    public void addSubscript(String subscriptSubPath) {
        if (this.subscriptList == null) {
            this.subscriptList = new LinkedList();
        }
        this.subscriptList.add(Integer.parseInt(subscriptSubPath.trim()));
    }
}

