/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.ws.rs.Path;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.hk2.utilities.binding.BindingBuilder;
import org.glassfish.hk2.utilities.binding.ServiceBindingBuilder;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.server.spi.ComponentProvider;
import org.jvnet.hk2.spring.bridge.api.SpringBridge;
import org.jvnet.hk2.spring.bridge.api.SpringIntoHK2Bridge;
import org.smallmind.scribe.pen.LoggerManager;
import org.smallmind.web.jersey.spring.AutowiredInjectionResolver;
import org.smallmind.web.jersey.spring.ExposedApplicationContext;
import org.smallmind.web.jersey.spring.SpringHK2IntegrationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;

public class SpringComponentProvider
implements ComponentProvider {
    private ServiceLocator serviceLocator;
    private ApplicationContext applicationContext;

    public void initialize(ServiceLocator serviceLocator) {
        LoggerManager.getLogger(SpringComponentProvider.class).info("Searching for Spring application context on Thread(%s)", new Object[]{Thread.currentThread().getName()});
        this.applicationContext = ExposedApplicationContext.getApplicationContext();
        if (this.applicationContext == null) {
            throw new SpringHK2IntegrationException("Spring application context has not been created prior to HK2 application initialization", new Object[0]);
        }
        this.serviceLocator = serviceLocator;
        SpringBridge.getSpringBridge().initializeSpringBridge(serviceLocator);
        SpringIntoHK2Bridge springBridge = (SpringIntoHK2Bridge)serviceLocator.getService(SpringIntoHK2Bridge.class, new Annotation[0]);
        springBridge.bridgeSpringBeanFactory((BeanFactory)this.applicationContext);
        ServiceLocatorUtilities.addOneConstant((ServiceLocator)serviceLocator, (Object)new AutowiredInjectionResolver(this.applicationContext));
        ServiceLocatorUtilities.addOneConstant((ServiceLocator)serviceLocator, (Object)this.applicationContext, (String)"SpringContext", (Type[])new Type[]{ApplicationContext.class});
    }

    public boolean bind(Class<?> component, Set<Class<?>> providerContracts) {
        if (component.isAnnotationPresent(Path.class)) {
            String[] beanNames = this.applicationContext.getBeanNamesForType(component);
            if (beanNames == null || beanNames.length == 0) {
                LoggerManager.getLogger(SpringComponentProvider.class).warn("The Spring context failed to contain a bean of type(%s) - unable to bind into HK2 ", new Object[]{component.getName()});
            } else if (beanNames.length > 1) {
                LoggerManager.getLogger(SpringComponentProvider.class).warn("The Spring context contained multiple beans of type(%s) - unable to bind into HK2", new Object[]{component.getName()});
            } else {
                DynamicConfiguration dynamicConfiguration = Injections.getConfiguration((ServiceLocator)this.serviceLocator);
                ServiceBindingBuilder serviceBindingBuilder = Injections.newFactoryBinder((Factory)new SpringManagedBeanFactory(this.serviceLocator, this.applicationContext, beanNames[0]));
                serviceBindingBuilder.to(component);
                Injections.addBinding((BindingBuilder)serviceBindingBuilder, (DynamicConfiguration)dynamicConfiguration);
                dynamicConfiguration.commit();
                LoggerManager.getLogger(SpringComponentProvider.class).info("Bound the Spring bean(%s) into the HK2 context", new Object[]{beanNames[0]});
                return true;
            }
        }
        return false;
    }

    public void done() {
    }

    private static class SpringManagedBeanFactory
    implements Factory {
        private ApplicationContext applicationContext;
        private ServiceLocator serviceLocator;
        private String beanName;
        private boolean singleton;

        private SpringManagedBeanFactory(ServiceLocator serviceLocator, ApplicationContext applicationContext, String beanName) {
            this.serviceLocator = serviceLocator;
            this.applicationContext = applicationContext;
            this.beanName = beanName;
            this.singleton = applicationContext.isSingleton(beanName);
            if (this.singleton) {
                serviceLocator.inject(applicationContext.getBean(beanName));
            }
        }

        public Object provide() {
            Object bean = this.applicationContext.getBean(this.beanName);
            if (!this.singleton) {
                this.serviceLocator.inject(bean);
            }
            return bean;
        }

        public void dispose(Object instance) {
        }
    }
}

