/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.smallmind.nutsnbolts.util.IterableIterator;
import org.smallmind.web.jersey.util.JsonCodec;

public abstract class SimpleMapXmlAdapter<M extends Map<String, V>, V>
extends XmlAdapter<JsonNode, M> {
    public abstract M getEmptyMap();

    public abstract Class<V> getValueClass();

    public M unmarshal(JsonNode node) {
        if (node != null) {
            M map = this.getEmptyMap();
            for (Map.Entry entry : new IterableIterator(node.fields())) {
                map.put((String)("null".equals(entry.getKey()) ? null : (String)entry.getKey()), JsonCodec.convert(entry.getValue(), this.getValueClass()));
            }
            return map;
        }
        return null;
    }

    public JsonNode marshal(M map) throws Exception {
        if (map != null) {
            ObjectNode rootNode = JsonNodeFactory.instance.objectNode();
            for (Map.Entry entry : map.entrySet()) {
                rootNode.set(entry.getKey() == null ? "null" : (String)entry.getKey(), JsonCodec.writeAsJsonNode(entry.getValue()));
            }
            return rootNode;
        }
        return null;
    }
}

