/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.persistence.hibernate;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.smallmind.web.jersey.util.JsonCodec;

public class JsonUserType
implements UserType,
ParameterizedType {
    private Class embeddedClass;

    public void setParameterValues(Properties parameters) {
        String objectClassName = parameters.getProperty("embeddedClassName");
        try {
            this.embeddedClass = Class.forName(objectClassName);
            if (!Serializable.class.isAssignableFrom(this.embeddedClass)) {
                throw new HibernateException("Embedded class(" + this.embeddedClass + ") must be Serializable");
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException((Throwable)cnfe);
        }
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y;
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        String string = rs.getString(names[0]);
        try {
            return rs.wasNull() ? null : JsonCodec.read(string, this.embeddedClass);
        }
        catch (IOException ioException) {
            throw new HibernateException((Throwable)ioException);
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, -16);
        } else {
            try {
                st.setString(index, JsonCodec.writeAsString(value));
            }
            catch (JsonProcessingException jsonProcessingException) {
                throw new HibernateException((Throwable)jsonProcessingException);
            }
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public Class returnedClass() {
        return this.embeddedClass;
    }

    public int[] sqlTypes() {
        return new int[]{-1};
    }
}

