/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.aop;

import org.glassfish.jersey.server.ContainerRequest;
import org.smallmind.nutsnbolts.reflection.MissingAnnotationException;
import org.smallmind.web.jersey.aop.JsonEntity;
import org.smallmind.web.jersey.aop.ParameterAnnotations;
import org.smallmind.web.jersey.aop.ResourceMethod;

public class EntityTranslator {
    private static final ThreadLocal<JsonEntity> JSON_ENTITY_LOCAL = new ThreadLocal();
    private static final ThreadLocal<Class<? extends JsonEntity>> JSON_ENTITY_CLASS_LOCAL = new ThreadLocal();

    public static <E extends JsonEntity> void storeEntityType(Class<E> clazz) {
        JSON_ENTITY_CLASS_LOCAL.set(clazz);
    }

    public static <T> T getParameter(ContainerRequest containerRequest, String key, Class<T> clazz, ParameterAnnotations parameterAnnotations) {
        JsonEntity jsonEntity = JSON_ENTITY_LOCAL.get();
        if (jsonEntity == null) {
            Class<? extends JsonEntity> entityClass = JSON_ENTITY_CLASS_LOCAL.get();
            if (entityClass == null) {
                throw new MissingAnnotationException("Missing annotation(%s)", new Object[]{ResourceMethod.class.getName()});
            }
            jsonEntity = (JsonEntity)containerRequest.readEntity(entityClass);
            JSON_ENTITY_LOCAL.set(jsonEntity);
        }
        try {
            return jsonEntity.getParameter(key, clazz, parameterAnnotations);
        }
        catch (Throwable throwable) {
            JSON_ENTITY_LOCAL.remove();
            throw throwable;
        }
    }

    public static void clearEntity() {
        JSON_ENTITY_LOCAL.remove();
    }
}

