/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.reflection;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.smallmind.nutsnbolts.reflection.bean.BeanAccessException;
import org.smallmind.nutsnbolts.reflection.bean.BeanUtility;
import org.smallmind.web.jersey.reflection.ComponentParser;
import org.smallmind.web.jersey.reflection.PathComponent;
import org.smallmind.web.jersey.util.JsonCodec;

public class BeanReflector {
    public Object get(Object target, String methodChain) throws BeanAccessException {
        PathComponent[] components = ComponentParser.parse(methodChain);
        if (components[components.length - 1].getArguments() != null) {
            throw new BeanAccessException("The last path component in the chain must not specify any arguments", new Object[0]);
        }
        return this.applySubscripts(this.executeGetter(this.traverse(target, components), components[components.length - 1].getName()), components[components.length - 1].getSubscripts());
    }

    public Object set(Object target, String methodChain, Object value) throws BeanAccessException {
        PathComponent[] components = ComponentParser.parse(methodChain);
        if (components[components.length - 1].getArguments() != null) {
            throw new BeanAccessException("The last path component in the chain must not specify any arguments", new Object[0]);
        }
        return this.executeSetter(this.traverse(target, components), components[components.length - 1].getName(), components[components.length - 1].getSubscripts(), value);
    }

    public Object apply(Object target, String methodChain, Object ... values) throws BeanAccessException {
        PathComponent[] components = ComponentParser.parse(methodChain);
        if (components[components.length - 1].getArguments() != null) {
            throw new BeanAccessException("The last path component in the chain must not specify any arguments", new Object[0]);
        }
        return this.applySubscripts(this.executeMethod(this.traverse(target, components), components[components.length - 1].getName(), values), components[components.length - 1].getSubscripts());
    }

    private Object traverse(Object target, PathComponent[] components) throws BeanAccessException {
        Object currentTarget = target;
        int index = 0;
        while (index < components.length - 1) {
            currentTarget = this.executeGetterOrMethod(currentTarget, components[index]);
            ++index;
        }
        return currentTarget;
    }

    private Object executeGetterOrMethod(Object target, PathComponent component) throws BeanAccessException {
        if (component.getArguments() != null) {
            return this.applySubscripts(this.executeMethod(target, component.getName(), component.getArguments()), component.getSubscripts());
        }
        return this.applySubscripts(this.executeGetter(target, component.getName()), component.getSubscripts());
    }

    private Object executeGetter(Object target, String name) throws BeanAccessException {
        Field field;
        if (target == null) {
            throw new BeanAccessException("Can not execute getter(%s) on a 'null' target", new Object[]{name});
        }
        Method method = null;
        try {
            method = target.getClass().getMethod(BeanUtility.asGetterName((String)name), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                method = target.getClass().getMethod(BeanUtility.asIsName((String)name), new Class[0]);
                if (!Boolean.class.equals(method.getReturnType()) && !Boolean.TYPE.equals(method.getReturnType())) {
                    throw new BeanAccessException("Found an 'is' method(%s) in class(%s), but it doesn't return a 'boolean' type", new Object[]{method.getName(), target.getClass().getName()});
                }
            }
            catch (NoSuchMethodException noSuchMethodException2) {}
        }
        if (method != null) {
            try {
                return method.invoke(target, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException exception) {
                throw new BeanAccessException((Throwable)exception);
            }
        }
        try {
            field = target.getClass().getField(name);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new BeanAccessException("No 'getter' method(%s or %s) or field(%s) found in class(%s)", new Object[]{BeanUtility.asGetterName((String)name), BeanUtility.asIsName((String)name), name, target.getClass().getName()});
        }
        try {
            return field.get(target);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BeanAccessException((Throwable)illegalAccessException);
        }
    }

    private Object executeSetter(Object target, String name, int[] subscripts, Object value) throws BeanAccessException {
        Field field;
        if (target == null) {
            throw new BeanAccessException("Can not execute setter(%s) on a 'null' target", new Object[]{name});
        }
        String setterName = BeanUtility.asSetterName((String)name);
        Method[] methodArray = target.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (setterName.equals(method.getName()) && method.getParameterCount() == 1) {
                if (subscripts != null && subscripts.length > 0) {
                    try {
                        method.invoke(target, this.applyIndexedValue(target, name, subscripts, value));
                    }
                    catch (IllegalAccessException | InvocationTargetException exception) {
                        throw new BeanAccessException((Throwable)exception);
                    }
                    return null;
                }
                try {
                    return method.invoke(target, value == null ? null : JsonCodec.convert(value, method.getParameterTypes()[0]));
                }
                catch (IllegalAccessException | InvocationTargetException exception) {
                    throw new BeanAccessException((Throwable)exception);
                }
            }
            ++n2;
        }
        try {
            field = target.getClass().getField(name);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new BeanAccessException("No 'setter' method(%s) or field(%s) found in class(%s)", new Object[]{BeanUtility.asSetterName((String)name), name, target.getClass().getName()});
        }
        if (subscripts != null && subscripts.length > 0) {
            try {
                field.set(target, this.applyIndexedValue(target, name, subscripts, value));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new BeanAccessException((Throwable)illegalAccessException);
            }
        }
        try {
            field.set(target, value == null ? null : JsonCodec.convert(value, field.getType()));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BeanAccessException((Throwable)illegalAccessException);
        }
        return null;
    }

    private Object applyIndexedValue(Object target, String name, int[] subscripts, Object value) throws BeanAccessException {
        Object currentValue = this.executeGetter(target, name);
        Object penultimateValue = this.applySubscripts(currentValue, Arrays.copyOf(subscripts, subscripts.length - 1));
        if (penultimateValue == null) {
            throw new BeanAccessException("Unable to apply the %s subscript(%d) to a 'null' value", new Object[]{this.indexToNth(subscripts.length - 1), subscripts[subscripts.length - 1]});
        }
        Class<?> penultimateComponentType = penultimateValue.getClass().getComponentType();
        if (penultimateComponentType == null) {
            throw new BeanAccessException("Unable to apply the %s subscript(%d) to value type(%s)", new Object[]{this.indexToNth(subscripts.length - 1), subscripts[subscripts.length - 1], penultimateValue.getClass()});
        }
        Array.set(penultimateValue, subscripts[subscripts.length - 1], value == null ? null : JsonCodec.convert(value, penultimateComponentType));
        return currentValue;
    }

    private Object executeMethod(Object target, String name, Object[] arguments) throws BeanAccessException {
        if (target == null) {
            throw new BeanAccessException("Can not execute method(%s) on a 'null' target", new Object[]{name});
        }
        Method[] methodArray = target.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(name) && method.getParameterCount() == (arguments == null ? 0 : arguments.length)) {
                Object[] parameterValues = new Object[method.getParameterCount()];
                boolean matched = true;
                if (arguments != null && arguments.length > 0) {
                    try {
                        int index = 0;
                        Class<?>[] classArray = method.getParameterTypes();
                        int n3 = classArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Class<?> parameterType = classArray[n4];
                            parameterValues[index] = arguments[index] == null ? null : JsonCodec.convert(arguments[index], parameterType);
                            ++index;
                            ++n4;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        matched = false;
                    }
                }
                if (matched) {
                    try {
                        return method.invoke(target, parameterValues);
                    }
                    catch (IllegalAccessException | InvocationTargetException exception) {
                        throw new BeanAccessException((Throwable)exception);
                    }
                }
            }
            ++n2;
        }
        try {
            throw new BeanAccessException("No method(name=%s, arguments=%s) found in class(%s)", new Object[]{name, JsonCodec.writeAsString(arguments), target.getClass().getName()});
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new BeanAccessException((Throwable)jsonProcessingException);
        }
    }

    private Object applySubscripts(Object value, int[] subscripts) throws BeanAccessException {
        Object indexedValue = value;
        if (subscripts != null && subscripts.length > 0) {
            int index = 0;
            while (index < subscripts.length) {
                if (indexedValue == null) {
                    throw new BeanAccessException("Unable to apply the %s subscript(%d) to a 'null' value", new Object[]{this.indexToNth(index), subscripts[index]});
                }
                if (!indexedValue.getClass().isArray()) {
                    throw new BeanAccessException("Unable to apply the %s subscript(%d) to value type(%s)", new Object[]{this.indexToNth(index), subscripts[index], indexedValue.getClass()});
                }
                try {
                    indexedValue = Array.get(indexedValue, subscripts[index]);
                }
                catch (Exception exception) {
                    throw new BeanAccessException((Throwable)exception, "Unable to apply the %s subscript(%d)", new Object[]{this.indexToNth(index), subscripts[index]});
                }
                ++index;
            }
        }
        return indexedValue;
    }

    private String indexToNth(int index) {
        switch (index) {
            case 0: {
                return "1st";
            }
            case 1: {
                return "2nd";
            }
            case 2: {
                return "3rd";
            }
        }
        return String.valueOf(String.valueOf(index + 1)) + "th";
    }
}

