/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.proxy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.WebApplicationException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.smallmind.nutsnbolts.http.HttpMethod;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.nutsnbolts.util.Pair;
import org.smallmind.nutsnbolts.util.Tuple;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.LoggerManager;
import org.smallmind.web.json.scaffold.util.JsonCodec;

public class JsonTarget {
    private final CloseableHttpClient httpClient;
    private final URI uri;
    private Tuple<String, String> headers;
    private Tuple<String, String> queryParameters;
    private Level level = Level.OFF;

    public JsonTarget(CloseableHttpClient httpClient, URI uri) {
        this.httpClient = httpClient;
        this.uri = uri;
    }

    public JsonTarget path(String path) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder().setScheme(this.uri.getScheme()).setUserInfo(this.uri.getUserInfo()).setHost(this.uri.getHost()).setPort(this.uri.getPort()).setPath(this.uri.getPath()).setCustomQuery(this.uri.getQuery()).setFragment(this.uri.getFragment());
        URI pathURI = URI.create(path);
        if (pathURI.getScheme() != null) {
            uriBuilder.setScheme(pathURI.getScheme());
        }
        if (pathURI.getUserInfo() != null) {
            uriBuilder.setUserInfo(pathURI.getUserInfo());
        }
        if (pathURI.getHost() != null) {
            uriBuilder.setHost(pathURI.getHost());
        }
        if (pathURI.getPort() > 0) {
            uriBuilder.setPort(pathURI.getPort());
        }
        if (pathURI.getPath() != null) {
            uriBuilder.setPath(this.uri.getPath() == null ? pathURI.getPath() : String.valueOf(this.uri.getPath()) + pathURI.getPath());
        }
        if (pathURI.getRawQuery() != null) {
            uriBuilder.setCustomQuery(this.uri.getRawQuery() == null ? pathURI.getQuery() : String.valueOf(this.uri.getQuery()) + "&" + pathURI.getQuery());
        }
        if (pathURI.getFragment() != null) {
            uriBuilder.setFragment(pathURI.getFragment());
        }
        return new JsonTarget(this.httpClient, uriBuilder.build());
    }

    public JsonTarget header(String key, String value) {
        if (this.headers == null) {
            this.headers = new Tuple();
        }
        this.headers.addPair((Object)key, (Object)value);
        return this;
    }

    public JsonTarget query(String key, String value) {
        if (this.queryParameters == null) {
            this.queryParameters = new Tuple();
        }
        this.queryParameters.addPair((Object)key, (Object)value);
        return this;
    }

    public JsonTarget debug(Level level) {
        this.level = level;
        return this;
    }

    public <T> T get(Class<T> responseClass) throws IOException, URISyntaxException {
        HttpGet httpGet = (HttpGet)this.createHttpRequest(HttpMethod.GET, null);
        LoggerManager.getLogger(JsonTarget.class).log(this.level, (Object)new RequestDebugCollector((HttpRequest)httpGet, null));
        Throwable throwable = null;
        Object var4_5 = null;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            return this.convertEntity((HttpResponse)response, responseClass);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public <T> T put(HttpEntity entity, Class<T> responseClass) throws IOException, URISyntaxException {
        HttpPut httpPut = (HttpPut)this.createHttpRequest(HttpMethod.PUT, entity);
        httpPut.setEntity(entity);
        LoggerManager.getLogger(JsonTarget.class).log(this.level, (Object)new RequestDebugCollector((HttpRequest)httpPut, entity));
        Throwable throwable = null;
        Object var5_6 = null;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPut);){
            return this.convertEntity((HttpResponse)response, responseClass);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public <T> T post(HttpEntity entity, Class<T> responseClass) throws IOException, URISyntaxException {
        HttpPost httpPost = (HttpPost)this.createHttpRequest(HttpMethod.POST, entity);
        httpPost.setEntity(entity);
        LoggerManager.getLogger(JsonTarget.class).log(this.level, (Object)new RequestDebugCollector((HttpRequest)httpPost, entity));
        Throwable throwable = null;
        Object var5_6 = null;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            return this.convertEntity((HttpResponse)response, responseClass);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public <T> T patch(HttpEntity entity, Class<T> responseClass) throws IOException, URISyntaxException {
        HttpPatch httpPatch = (HttpPatch)this.createHttpRequest(HttpMethod.PATCH, entity);
        httpPatch.setEntity(entity);
        LoggerManager.getLogger(JsonTarget.class).log(this.level, (Object)new RequestDebugCollector((HttpRequest)httpPatch, entity));
        Throwable throwable = null;
        Object var5_6 = null;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPatch);){
            return this.convertEntity((HttpResponse)response, responseClass);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public <T> T delete(Class<T> responseClass) throws IOException, URISyntaxException {
        HttpDelete httpDelete = (HttpDelete)this.createHttpRequest(HttpMethod.DELETE, null);
        LoggerManager.getLogger(JsonTarget.class).log(this.level, (Object)new RequestDebugCollector((HttpRequest)httpDelete, null));
        Throwable throwable = null;
        Object var4_5 = null;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpDelete);){
            return this.convertEntity((HttpResponse)response, responseClass);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private <T> T convertEntity(HttpResponse response, Class<T> responseClass) throws IOException {
        InputStreamHolder entityInputStreamHolder;
        HttpEntity entity = response.getEntity();
        if (entity == null || entity.getContentLength() == 0L || (entityInputStreamHolder = new InputStreamHolder(entity.getContent())).isEmpty()) {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine == null || statusLine.getStatusCode() >= 200 && statusLine.getStatusCode() < 300) {
                return null;
            }
            throw new WebApplicationException(statusLine.getReasonPhrase(), statusLine.getStatusCode());
        }
        LoggerManager.getLogger(JsonTarget.class).log(this.level, (Object)new ResponseDebugCollector(response, entityInputStreamHolder));
        return (T)JsonCodec.read((InputStream)entityInputStreamHolder.getInputStream(), responseClass);
    }

    private HttpRequest createHttpRequest(HttpMethod httpMethod, HttpEntity entity) throws URISyntaxException {
        Header contentTypeHeader;
        HttpGet httpRequest;
        block19: {
            block18: {
                if (this.queryParameters != null) break block18;
                switch (httpMethod) {
                    case GET: {
                        httpRequest = new HttpGet(this.uri);
                        break block19;
                    }
                    case PUT: {
                        httpRequest = new HttpPut(this.uri);
                        break block19;
                    }
                    case POST: {
                        httpRequest = new HttpPost(this.uri);
                        break block19;
                    }
                    case PATCH: {
                        httpRequest = new HttpPatch(this.uri);
                        break block19;
                    }
                    case DELETE: {
                        httpRequest = new HttpDelete(this.uri);
                        break block19;
                    }
                    default: {
                        throw new UnknownSwitchCaseException(httpMethod.name(), new Object[0]);
                    }
                }
            }
            URIBuilder uriBuilder = new URIBuilder(this.uri);
            for (Pair queryPair : this.queryParameters) {
                uriBuilder.addParameter((String)queryPair.getFirst(), (String)queryPair.getSecond());
            }
            switch (httpMethod) {
                case GET: {
                    httpRequest = new HttpGet(uriBuilder.build());
                    break;
                }
                case PUT: {
                    httpRequest = new HttpPut(uriBuilder.build());
                    break;
                }
                case POST: {
                    httpRequest = new HttpPost(uriBuilder.build());
                    break;
                }
                case PATCH: {
                    httpRequest = new HttpPatch(uriBuilder.build());
                    break;
                }
                case DELETE: {
                    httpRequest = new HttpDelete(uriBuilder.build());
                    break;
                }
                default: {
                    throw new UnknownSwitchCaseException(httpMethod.name(), new Object[0]);
                }
            }
        }
        if (this.headers != null) {
            for (Pair headerPair : this.headers) {
                httpRequest.addHeader((String)headerPair.getFirst(), (String)headerPair.getSecond());
            }
        }
        if (entity != null && (contentTypeHeader = entity.getContentType()) != null) {
            httpRequest.setHeader(contentTypeHeader.getName(), contentTypeHeader.getValue());
        }
        return httpRequest;
    }

    private class InputStreamHolder {
        private InputStream inputStream;

        private InputStreamHolder(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        private InputStream getInputStream() {
            return this.inputStream;
        }

        private void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public boolean isEmpty() {
            return this.inputStream == null;
        }
    }

    private class RequestDebugCollector {
        private HttpRequest httpRequest;
        private HttpEntity entity;

        private RequestDebugCollector(HttpRequest httpRequest, HttpEntity entity) {
            this.httpRequest = httpRequest;
            this.entity = entity;
        }

        public String toString() {
            StringBuilder debugBuilder = new StringBuilder();
            debugBuilder.append("Sending client request\n");
            debugBuilder.append("< ").append(this.httpRequest.getRequestLine()).append('\n');
            Header[] headerArray = this.httpRequest.getAllHeaders();
            int n = headerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                debugBuilder.append("< ").append(header.getName()).append(": ").append(header.getValue()).append('\n');
                ++n2;
            }
            if (this.entity != null) {
                try {
                    debugBuilder.append(EntityUtils.toString((HttpEntity)this.entity)).append('\n');
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            }
            return debugBuilder.toString();
        }
    }

    private class ResponseDebugCollector {
        private HttpResponse response;
        private InputStreamHolder entityInputStreamHolder;

        private ResponseDebugCollector(HttpResponse response, InputStreamHolder entityInputStreamHolder) {
            this.response = response;
            this.entityInputStreamHolder = entityInputStreamHolder;
        }

        public String toString() {
            StringBuilder debugBuilder = new StringBuilder();
            InputStream entityInputStream = this.entityInputStreamHolder.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            debugBuilder.append("Receiving client response\n");
            debugBuilder.append("< ").append(this.response.getStatusLine().getStatusCode()).append('\n');
            Header[] headerArray = this.response.getAllHeaders();
            int n = headerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                debugBuilder.append("< ").append(header.getName()).append(": ").append(header.getValue()).append('\n');
                ++n2;
            }
            try {
                int singleByte;
                while ((singleByte = entityInputStream.read()) >= 0) {
                    byteArrayOutputStream.write(singleByte);
                }
                byteArrayOutputStream.close();
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            this.entityInputStreamHolder.setInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            debugBuilder.append(new String(byteArrayOutputStream.toByteArray())).append('\n');
            return debugBuilder.toString();
        }
    }
}

