/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.spring;

import org.glassfish.jersey.server.ResourceConfig;
import org.smallmind.web.jersey.json.JsonProvider;
import org.smallmind.web.jersey.spring.HK2ResourceBeanPostProcessor;
import org.smallmind.web.jersey.spring.ResourceConfigExtension;
import org.smallmind.web.jersey.spring.SpringHK2IntegrationException;
import org.springframework.context.ApplicationContext;

public class JerseyResourceConfig
extends ResourceConfig {
    public JerseyResourceConfig(ApplicationContext applicationContext, ResourceConfigExtension[] extensions) {
        if (applicationContext == null) {
            throw new SpringHK2IntegrationException("Spring application context must not be 'null'", new Object[0]);
        }
        HK2ResourceBeanPostProcessor hk2ResourceBeanPostProcessor = (HK2ResourceBeanPostProcessor)applicationContext.getBean(HK2ResourceBeanPostProcessor.class);
        if (hk2ResourceBeanPostProcessor == null) {
            throw new SpringHK2IntegrationException("Spring application context must include the %s", HK2ResourceBeanPostProcessor.class.getSimpleName());
        }
        this.register(JsonProvider.class);
        if (extensions != null) {
            ResourceConfigExtension[] resourceConfigExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceConfigExtension extension = resourceConfigExtensionArray[n2];
                extension.apply(this);
                ++n2;
            }
        }
        hk2ResourceBeanPostProcessor.registerResources(this);
    }
}

