/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.spring;

import java.util.Set;
import java.util.function.Supplier;
import org.glassfish.jersey.inject.hk2.ImmediateHk2InjectionManager;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.Bindings;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.server.spi.ComponentProvider;
import org.jvnet.hk2.spring.bridge.api.SpringBridge;
import org.jvnet.hk2.spring.bridge.api.SpringIntoHK2Bridge;
import org.smallmind.scribe.pen.LoggerManager;
import org.smallmind.web.jersey.spring.AutowiredInjectResolver;
import org.smallmind.web.jersey.spring.ExposedApplicationContext;
import org.smallmind.web.jersey.spring.SpringHK2IntegrationException;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

public class SpringHK2ComponentProvider
implements ComponentProvider {
    private volatile InjectionManager injectionManager;
    private volatile ApplicationContext applicationContext;

    public void initialize(InjectionManager injectionManager) {
        this.injectionManager = injectionManager;
        LoggerManager.getLogger(SpringHK2ComponentProvider.class).info("Searching for Spring application context on Thread(%s)", new Object[]{Thread.currentThread().getName()});
        this.applicationContext = ExposedApplicationContext.getApplicationContext();
        if (this.applicationContext == null) {
            throw new SpringHK2IntegrationException("Spring application context has not been created prior to HK2 application initialization", new Object[0]);
        }
        ImmediateHk2InjectionManager hk2InjectionManager = (ImmediateHk2InjectionManager)injectionManager;
        SpringBridge.getSpringBridge().initializeSpringBridge(hk2InjectionManager.getServiceLocator());
        SpringIntoHK2Bridge springBridge = (SpringIntoHK2Bridge)injectionManager.getInstance(SpringIntoHK2Bridge.class);
        springBridge.bridgeSpringBeanFactory((BeanFactory)this.applicationContext);
        injectionManager.register((Binding)Bindings.injectionResolver((InjectionResolver)new AutowiredInjectResolver(this.applicationContext)));
        injectionManager.register(((InstanceBinding)Bindings.service((Object)this.applicationContext).to(ApplicationContext.class)).named("SpringContext"));
    }

    public boolean bind(Class<?> component, Set<Class<?>> providerContracts) {
        if (this.applicationContext == null) {
            return false;
        }
        if (AnnotationUtils.findAnnotation(component, Component.class) == null) {
            return false;
        }
        String[] beanNames = this.applicationContext.getBeanNamesForType(component);
        if (beanNames == null || beanNames.length != 1) {
            return false;
        }
        String beanName = beanNames[0];
        Binding binding = Bindings.supplier((Supplier)new SpringManagedBeanFactory(this.applicationContext, this.injectionManager, beanName)).to(component).to(providerContracts);
        this.injectionManager.register(binding);
        return true;
    }

    public void done() {
    }

    private static class SpringManagedBeanFactory
    implements Supplier {
        private final ApplicationContext ctx;
        private final InjectionManager injectionManager;
        private final String beanName;

        private SpringManagedBeanFactory(ApplicationContext ctx, InjectionManager injectionManager, String beanName) {
            this.ctx = ctx;
            this.injectionManager = injectionManager;
            this.beanName = beanName;
        }

        public Object get() {
            Object bean = this.ctx.getBean(this.beanName);
            if (bean instanceof Advised) {
                try {
                    Object localBean = ((Advised)bean).getTargetSource().getTarget();
                    this.injectionManager.inject(localBean);
                }
                catch (Exception exception) {
                    this.injectionManager.inject(bean);
                }
            } else {
                this.injectionManager.inject(bean);
            }
            return bean;
        }
    }
}

