/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.json;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.smallmind.nutsnbolts.reflection.type.GenericUtility;
import org.smallmind.scribe.pen.LoggerManager;
import org.smallmind.web.jersey.json.ConcreteExceptionMapper;
import org.smallmind.web.json.scaffold.fault.Fault;
import org.smallmind.web.json.scaffold.fault.FaultWrappingException;

public class ThrowableExceptionMapper
implements ExceptionMapper<Throwable> {
    private final ExceptionMapper[] mappers;
    private final boolean logUnclassifiedErrors;

    public ThrowableExceptionMapper(ExceptionMapper ... mappers) {
        this(false, mappers);
    }

    public ThrowableExceptionMapper(boolean logUnclassifiedErrors, ExceptionMapper ... mappers) {
        this.logUnclassifiedErrors = logUnclassifiedErrors;
        this.mappers = mappers;
    }

    public Response toResponse(Throwable throwable) {
        if (this.mappers != null) {
            ExceptionMapper[] exceptionMapperArray = this.mappers;
            int n = this.mappers.length;
            int n2 = 0;
            while (n2 < n) {
                Response response;
                ExceptionMapper mapper = exceptionMapperArray[n2];
                Class mappedThrowableClass = (Class)GenericUtility.getTypeArguments(ConcreteExceptionMapper.class, mapper.getClass()).get(0);
                if (mappedThrowableClass.isAssignableFrom(throwable.getClass()) && (response = mapper.toResponse(throwable)) != null) {
                    return response;
                }
                ++n2;
            }
        }
        if (throwable instanceof WebApplicationException) {
            Response response;
            if (this.logUnclassifiedErrors && (response = ((WebApplicationException)throwable).getResponse()) != null && response.getStatus() == 500) {
                LoggerManager.getLogger(ThrowableExceptionMapper.class).error(throwable);
            }
            return ((WebApplicationException)throwable).getResponse();
        }
        if (this.logUnclassifiedErrors) {
            LoggerManager.getLogger(ThrowableExceptionMapper.class).error(throwable);
        }
        return Response.status((int)500).type("application/json").entity((Object)(throwable instanceof FaultWrappingException ? ((FaultWrappingException)throwable).getFault() : new Fault(throwable))).build();
    }
}

