/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.proxy;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicHeader;
import org.smallmind.web.json.scaffold.util.JsonCodec;

public class JsonHttpEntity
extends AbstractHttpEntity {
    private static final Header CONTENT_TYPE_HEADER = new BasicHeader("Content-type", "application/json");
    private final byte[] bytes;

    public JsonHttpEntity(Object obj) throws JsonProcessingException {
        this.bytes = JsonCodec.writeAsBytes((Object)obj);
    }

    public static JsonHttpEntity entity(Object obj) throws JsonProcessingException {
        return new JsonHttpEntity(obj);
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.bytes.length;
    }

    public Header getContentType() {
        return CONTENT_TYPE_HEADER;
    }

    public boolean isChunked() {
        return true;
    }

    public InputStream getContent() {
        return new ByteArrayInputStream(this.bytes);
    }

    public void writeTo(OutputStream outstream) throws IOException {
        outstream.write(this.bytes);
    }

    public boolean isStreaming() {
        return false;
    }
}

