/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.cors;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;

public class CorsResponseFilter
implements ContainerResponseFilter {
    private final String allowedHeaders;
    private final String exposedHeaders;

    public CorsResponseFilter(String allowedHeaders, String exposedHeaders) {
        this.allowedHeaders = allowedHeaders;
        this.exposedHeaders = exposedHeaders;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        String originHeader = requestContext.getHeaderString("Origin");
        if (originHeader != null && !originHeader.isEmpty()) {
            responseContext.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)originHeader);
        } else {
            responseContext.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)"*");
        }
        if (this.allowedHeaders != null) {
            responseContext.getHeaders().add((Object)"Access-Control-Allow-Headers", (Object)this.allowedHeaders);
        }
        if (this.exposedHeaders != null) {
            responseContext.getHeaders().add((Object)"Access-Control-Expose-Headers", (Object)this.exposedHeaders);
        }
        responseContext.getHeaders().add((Object)"Access-Control-Allow-Methods", (Object)"DELETE, GET, HEAD, OPTIONS, PATCH, POST, PUT");
        responseContext.getHeaders().add((Object)"Access-Control-Allow-Credentials", (Object)"true");
    }
}

