/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.aop;

import java.util.Arrays;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.ValidationException;

public class EntityValidationException
extends ValidationException {
    public <T> EntityValidationException(Set<ConstraintViolation<T>> constraintViolationSet) {
        super(EntityValidationException.convert(constraintViolationSet));
    }

    private static <T> String convert(Set<ConstraintViolation<T>> constraintViolationSet) {
        Object[] violations = new Violation[constraintViolationSet.size()];
        int index = 0;
        for (ConstraintViolation<T> constraintViolation : constraintViolationSet) {
            violations[index++] = new Violation(constraintViolation);
        }
        return Arrays.toString(violations);
    }

    private static class Violation {
        private final Path propertyPath;
        private final String message;

        public Violation(ConstraintViolation<?> constraintViolation) {
            this.propertyPath = constraintViolation.getPropertyPath();
            this.message = constraintViolation.getMessage();
        }

        public String toString() {
            return "{property_path = " + this.propertyPath + ", message = " + this.message + '}';
        }
    }
}

