/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.cors;

import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;

@PreMatching
public class CorsFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private final String allowedHeaders;
    private final String exposedHeaders;

    public CorsFilter(String allowedHeaders, String exposedHeaders) {
        this.allowedHeaders = allowedHeaders;
        this.exposedHeaders = exposedHeaders;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if ("OPTIONS".equals(requestContext.getMethod())) {
            Response.ResponseBuilder responseBuilder = Response.ok();
            String originHeader = requestContext.getHeaderString("Origin");
            if (originHeader != null && !originHeader.isEmpty()) {
                responseBuilder.header("Access-Control-Allow-Origin", (Object)originHeader);
            } else {
                responseBuilder.header("Access-Control-Allow-Origin", (Object)"*");
            }
            if (this.allowedHeaders != null) {
                responseBuilder.header("Access-Control-Allow-Headers", (Object)this.allowedHeaders);
            }
            if (this.exposedHeaders != null) {
                responseBuilder.header("Access-Control-Expose-Headers", (Object)this.exposedHeaders);
            }
            responseBuilder.header("Access-Control-Allow-Methods", (Object)"CONNECT,DELETE,GET,HEAD,OPTIONS,PATCH,POST,PUT");
            responseBuilder.header("Access-Control-Allow-Credentials", (Object)"true");
            requestContext.abortWith(responseBuilder.build());
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (!"OPTIONS".equals(requestContext.getMethod())) {
            String originHeader = requestContext.getHeaderString("Origin");
            if (originHeader != null && !originHeader.isEmpty()) {
                responseContext.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)originHeader);
            } else {
                responseContext.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)"*");
            }
            if (this.allowedHeaders != null) {
                responseContext.getHeaders().add((Object)"Access-Control-Allow-Headers", (Object)this.allowedHeaders);
            }
            if (this.exposedHeaders != null) {
                responseContext.getHeaders().add((Object)"Access-Control-Expose-Headers", (Object)this.exposedHeaders);
            }
            responseContext.getHeaders().add((Object)"Access-Control-Allow-Methods", (Object)"CONNECT,DELETE,GET,HEAD,OPTIONS,PATCH,POST,PUT");
            responseContext.getHeaders().add((Object)"Access-Control-Allow-Credentials", (Object)"true");
        }
    }
}

