/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.ssl;

import java.net.URI;
import java.security.AccessController;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.test.DeploymentContext;
import org.glassfish.jersey.test.JerseyTest;
import org.glassfish.jersey.test.spi.TestContainer;
import org.glassfish.jersey.test.spi.TestContainerException;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.junit.After;
import org.junit.Before;

public abstract class SSLJerseyTest {
    private static final Logger LOGGER = Logger.getLogger(JerseyTest.class.getName());
    private static Class<? extends TestContainerFactory> defaultTestContainerFactoryClass;
    private final DeploymentContext context;
    private final AtomicReference<Client> client = new AtomicReference<Object>(null);
    private final Map<String, String> propertyMap = new HashMap<String, String>();
    private final Map<String, String> forcedPropertyMap = new HashMap<String, String>();
    private final Map<Logger, Level> logLevelMap = new IdentityHashMap<Logger, Level>();
    private TestContainerFactory testContainerFactory;
    private TestContainer testContainer;

    public SSLJerseyTest() {
        this.context = this.configureDeployment();
        this.testContainerFactory = this.getTestContainerFactory();
    }

    public SSLJerseyTest(TestContainerFactory testContainerFactory) {
        this.context = this.configureDeployment();
        this.testContainerFactory = testContainerFactory;
    }

    public SSLJerseyTest(Application jaxrsApplication) {
        this.context = DeploymentContext.newInstance((Application)jaxrsApplication);
        this.testContainerFactory = this.getTestContainerFactory();
    }

    private static String getSystemProperty(String propertyName) {
        Properties systemProperties = (Properties)AccessController.doPrivileged(PropertiesHelper.getSystemProperties());
        return systemProperties.getProperty(propertyName);
    }

    private static synchronized TestContainerFactory getDefaultTestContainerFactory() {
        if (defaultTestContainerFactoryClass == null) {
            String factoryClassName = SSLJerseyTest.getSystemProperty("jersey.config.test.container.factory");
            if (factoryClassName != null) {
                LOGGER.log(Level.CONFIG, "Loading test container factory '{0}' specified in the '{1}' system property.", new Object[]{factoryClassName, "jersey.config.test.container.factory"});
                defaultTestContainerFactoryClass = SSLJerseyTest.loadFactoryClass(factoryClassName);
            } else {
                TestContainerFactory[] factories = (TestContainerFactory[])ServiceFinder.find(TestContainerFactory.class).toArray();
                if (factories.length > 0) {
                    if (factories.length == 1) {
                        defaultTestContainerFactoryClass = factories[0].getClass();
                        LOGGER.log(Level.CONFIG, "Using the single found TestContainerFactory service provider '{0}'", defaultTestContainerFactoryClass.getName());
                        return factories[0];
                    }
                    TestContainerFactory[] testContainerFactoryArray = factories;
                    int n = factories.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TestContainerFactory tcf = testContainerFactoryArray[n2];
                        if ("org.glassfish.jersey.test.grizzly.GrizzlyTestContainerFactory".equals(tcf.getClass().getName())) {
                            defaultTestContainerFactoryClass = tcf.getClass();
                            LOGGER.log(Level.CONFIG, "Found multiple TestContainerFactory service providers, using the default found '{0}'", "org.glassfish.jersey.test.grizzly.GrizzlyTestContainerFactory");
                            return tcf;
                        }
                        ++n2;
                    }
                    defaultTestContainerFactoryClass = factories[0].getClass();
                    LOGGER.log(Level.WARNING, "Found multiple TestContainerFactory service providers, using the first found '{0}'", defaultTestContainerFactoryClass.getName());
                    return factories[0];
                }
                LOGGER.log(Level.CONFIG, "No TestContainerFactory configured, trying to load and instantiate the default implementation '{0}'", "org.glassfish.jersey.test.grizzly.GrizzlyTestContainerFactory");
                defaultTestContainerFactoryClass = SSLJerseyTest.loadFactoryClass("org.glassfish.jersey.test.grizzly.GrizzlyTestContainerFactory");
            }
        }
        try {
            return defaultTestContainerFactoryClass.newInstance();
        }
        catch (Exception ex) {
            throw new TestContainerException(String.format("Could not instantiate test container factory '%s'", defaultTestContainerFactoryClass.getName()), (Throwable)ex);
        }
    }

    private static Class<? extends TestContainerFactory> loadFactoryClass(String factoryClassName) {
        Class loadedClass = (Class)AccessController.doPrivileged(ReflectionHelper.classForNamePA((String)factoryClassName, null));
        if (loadedClass == null) {
            throw new TestContainerException(String.format("Test container factory class '%s' cannot be loaded", factoryClassName));
        }
        try {
            return loadedClass.asSubclass(TestContainerFactory.class);
        }
        catch (ClassCastException ex) {
            throw new TestContainerException(String.format("Class '%s' does not implement TestContainerFactory SPI.", factoryClassName), (Throwable)ex);
        }
    }

    public static void closeIfNotNull(Client ... clients) {
        if (clients == null || clients.length == 0) {
            return;
        }
        Client[] clientArray = clients;
        int n = clients.length;
        int n2 = 0;
        while (n2 < n) {
            Client c = clientArray[n2];
            if (c != null) {
                try {
                    c.close();
                }
                catch (Throwable t) {
                    LOGGER.log(Level.WARNING, "Error closing a client instance.", t);
                }
            }
            ++n2;
        }
    }

    TestContainer getTestContainer() {
        return this.testContainer;
    }

    TestContainer setTestContainer(TestContainer testContainer) {
        TestContainer old = this.testContainer;
        this.testContainer = testContainer;
        return old;
    }

    private TestContainer createTestContainer(DeploymentContext context) {
        return this.getTestContainerFactory().create(this.getBaseUri(), context);
    }

    protected final void enable(String featureName) {
        this.propertyMap.put(featureName, Boolean.TRUE.toString());
    }

    protected final void disable(String featureName) {
        this.propertyMap.put(featureName, Boolean.FALSE.toString());
    }

    protected final void forceEnable(String featureName) {
        this.forcedPropertyMap.put(featureName, Boolean.TRUE.toString());
    }

    protected final void forceDisable(String featureName) {
        this.forcedPropertyMap.put(featureName, Boolean.FALSE.toString());
    }

    protected final void set(String propertyName, Object value) {
        this.set(propertyName, value.toString());
    }

    protected final void set(String propertyName, String value) {
        this.propertyMap.put(propertyName, value);
    }

    protected final void forceSet(String propertyName, String value) {
        this.forcedPropertyMap.put(propertyName, value);
    }

    protected final boolean isEnabled(String propertyName) {
        return Boolean.valueOf(this.getProperty(propertyName));
    }

    private String getProperty(String propertyName) {
        if (this.forcedPropertyMap.containsKey(propertyName)) {
            return this.forcedPropertyMap.get(propertyName);
        }
        Properties systemProperties = (Properties)AccessController.doPrivileged(PropertiesHelper.getSystemProperties());
        if (systemProperties.containsKey(propertyName)) {
            return systemProperties.getProperty(propertyName);
        }
        if (this.propertyMap.containsKey(propertyName)) {
            return this.propertyMap.get(propertyName);
        }
        return null;
    }

    protected Application configure() {
        throw new UnsupportedOperationException("The configure method must be implemented by the extending class");
    }

    protected DeploymentContext configureDeployment() {
        return DeploymentContext.builder((Application)this.configure()).build();
    }

    protected TestContainerFactory getTestContainerFactory() throws TestContainerException {
        if (this.testContainerFactory == null) {
            this.testContainerFactory = SSLJerseyTest.getDefaultTestContainerFactory();
        }
        return this.testContainerFactory;
    }

    public final WebTarget target() {
        return this.client().target(this.getTestContainer().getBaseUri());
    }

    public final WebTarget target(String path) {
        return this.target().path(path);
    }

    public final Client client() {
        return this.getClient();
    }

    @Before
    public void setUp() throws Exception {
        TestContainer testContainer = this.createTestContainer(this.context);
        this.setTestContainer(testContainer);
        testContainer.start();
        this.setClient(this.getClient(testContainer.getClientConfig()));
    }

    @After
    public void tearDown() throws Exception {
        try {
            TestContainer oldContainer = this.setTestContainer(null);
            if (oldContainer != null) {
                oldContainer.stop();
            }
        }
        catch (Throwable throwable) {
            SSLJerseyTest.closeIfNotNull(this.setClient(null));
            throw throwable;
        }
        SSLJerseyTest.closeIfNotNull(this.setClient(null));
    }

    protected Client getClient() {
        return this.client.get();
    }

    protected Client setClient(Client client) {
        return this.client.getAndSet(client);
    }

    private Client getClient(ClientConfig clientConfig) {
        if (clientConfig == null) {
            clientConfig = new ClientConfig();
        }
        if (this.isEnabled("jersey.config.test.logging.enable")) {
            clientConfig.register((Object)new LoggingFeature(LOGGER, this.isEnabled("jersey.config.test.logging.dumpEntity") ? LoggingFeature.Verbosity.PAYLOAD_ANY : LoggingFeature.Verbosity.HEADERS_ONLY));
        }
        this.configureClient(clientConfig);
        return ClientBuilder.newClient((Configuration)clientConfig);
    }

    protected void configureClient(ClientConfig config) {
    }

    protected URI getBaseUri() {
        TestContainer container = this.getTestContainer();
        if (container != null) {
            return container.getBaseUri();
        }
        return UriBuilder.fromUri((String)"http://localhost/").port(this.getPort()).build(new Object[0]);
    }

    protected final int getPort() {
        TestContainer container = this.getTestContainer();
        if (container != null) {
            return container.getBaseUri().getPort();
        }
        String value = this.getProperty("jersey.config.test.container.port");
        if (value != null) {
            try {
                int i = Integer.parseInt(value);
                if (i < 0) {
                    throw new NumberFormatException("Value not positive.");
                }
                return i;
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.CONFIG, "Value of jersey.config.test.container.port property is not a valid positive integer [" + value + "]." + " Reverting to default [" + 9998 + "].", e);
            }
        }
        return 9998;
    }

    public final void close(Response ... responses) {
        if (responses != null) {
            Response[] responseArray = responses;
            int n = responses.length;
            int n2 = 0;
            while (n2 < n) {
                Response response = responseArray[n2];
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.WARNING, "Error closing a response.", t);
                    }
                }
                ++n2;
            }
        }
    }
}

