/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.json;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.smallmind.web.jersey.json.XmlAdapterParamConversionException;

public class XmlAdapterParamConverterProvider
implements ParamConverterProvider {
    private final ConcurrentHashMap<Class<? extends XmlAdapter>, ParamConverter<?>> CONVERTER_MAP = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Class xmlAdapterClass;
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().equals(XmlJavaTypeAdapter.class) && (xmlAdapterClass = ((XmlJavaTypeAdapter)annotation).value()) != null) {
                ParamConverter<?> paramConverter = this.CONVERTER_MAP.get(xmlAdapterClass);
                if (paramConverter == null) {
                    ConcurrentHashMap<Class<? extends XmlAdapter>, ParamConverter<?>> concurrentHashMap = this.CONVERTER_MAP;
                    synchronized (concurrentHashMap) {
                        paramConverter = this.CONVERTER_MAP.get(xmlAdapterClass);
                        if (paramConverter == null) {
                            try {
                                this.CONVERTER_MAP.put(xmlAdapterClass, new XmlAdapterParamConverter((XmlAdapter)xmlAdapterClass.getConstructor(new Class[0]).newInstance(new Object[0])));
                            }
                            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                                throw new XmlAdapterParamConversionException(exception);
                            }
                        }
                    }
                }
                return paramConverter;
            }
            ++n2;
        }
        return null;
    }

    private static class XmlAdapterParamConverter<T>
    implements ParamConverter<T> {
        private final XmlAdapter<String, T> xmlAdapter;

        public XmlAdapterParamConverter(XmlAdapter<String, T> xmlAdapter) {
            this.xmlAdapter = xmlAdapter;
        }

        public T fromString(String value) {
            try {
                return (T)this.xmlAdapter.unmarshal((Object)value);
            }
            catch (Exception exception) {
                throw new XmlAdapterParamConversionException(exception);
            }
        }

        public String toString(T value) {
            try {
                return (String)this.xmlAdapter.marshal(value);
            }
            catch (Exception exception) {
                throw new XmlAdapterParamConversionException(exception);
            }
        }
    }
}

