/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.multipart;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.smallmind.web.jersey.multipart.MultiPartContentType;
import org.smallmind.web.jersey.multipart.MultiPartFile;

public class MultiPartFileIterator
implements Iterator<MultiPartFile> {
    private final Iterator<FormDataBodyPart> bodyPartIter;

    public MultiPartFileIterator(FormDataMultiPart formDataMultiPart) {
        List bodyPartList = formDataMultiPart.getFields("file");
        if (bodyPartList == null) {
            throw new IllegalArgumentException("You must specify a field name of 'file'");
        }
        this.bodyPartIter = bodyPartList.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.bodyPartIter.hasNext();
    }

    @Override
    public MultiPartFile next() {
        FormDataBodyPart bodyPart = this.bodyPartIter.next();
        return new MultiPartFile(bodyPart.getContentDisposition().getFileName(), this.getContentType((BodyPart)bodyPart), (InputStream)bodyPart.getValueAs(InputStream.class));
    }

    private String getContentType(BodyPart bodyPart) {
        MultiPartContentType multiPartContentType;
        if (bodyPart.getMediaType() != null) {
            return bodyPart.getMediaType().toString();
        }
        String fileName = bodyPart.getContentDisposition().getFileName();
        int lastPeriodPos = fileName.lastIndexOf(46);
        if (lastPeriodPos >= 0 && (multiPartContentType = MultiPartContentType.forExtension(fileName.substring(lastPeriodPos + 1))) != null) {
            return multiPartContentType.getContentType();
        }
        return "application/octet-stream";
    }
}

