/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.json;

import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.core.MediaType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.smallmind.web.json.scaffold.fault.Fault;
import org.smallmind.web.json.scaffold.fault.FaultWrappingException;
import org.smallmind.web.json.scaffold.fault.NativeLanguage;
import org.smallmind.web.json.scaffold.fault.NativeObject;
import org.smallmind.web.json.scaffold.fault.ObjectInstantiationException;
import org.smallmind.web.json.scaffold.fault.ResourceInvocationException;
import org.smallmind.web.json.scaffold.util.JsonCodec;

public class FaultTranslatingClientResponseFilter
implements ClientResponseFilter {
    private final int lowerBound;
    private final int upperBound;

    public FaultTranslatingClientResponseFilter() {
        this(400, 600);
    }

    public FaultTranslatingClientResponseFilter(int lowerBound, int upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (responseContext.getStatus() >= this.lowerBound && responseContext.getStatus() < this.upperBound && MediaType.APPLICATION_JSON_TYPE.equals((Object)responseContext.getMediaType()) && responseContext.hasEntity()) {
            Fault fault = (Fault)JsonCodec.read((InputStream)responseContext.getEntityStream(), Fault.class);
            NativeObject nativeObject = fault.getNativeObject();
            if (nativeObject != null && nativeObject.getLanguage().equals((Object)NativeLanguage.JAVA)) {
                Throwable throwable = null;
                Object var6_7 = null;
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(nativeObject.getBytes());
                    try {
                        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                        try {
                            try {
                                throw new ResourceInvocationException((Throwable)objectInputStream.readObject());
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new ObjectInstantiationException(classNotFoundException);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (byteArrayInputStream != null) {
                            byteArrayInputStream.close();
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            throw new FaultWrappingException(fault);
        }
    }
}

