/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.page;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import org.smallmind.web.jersey.page.PageRange;
import org.smallmind.web.json.scaffold.util.Page;

public class PageRangeResponseFilter
implements ContainerResponseFilter {
    public static int HTTP_DATA_COMPLETE = 200;
    public static int HTTP_DATA_INCOMPLETE = 206;
    public static int HTTP_DATA_OUT_OF_RANGE = 416;
    @Context
    ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        Class entityClass;
        if (this.resourceInfo.getResourceMethod() != null && this.resourceInfo.getResourceMethod().getAnnotation(PageRange.class) != null && (entityClass = responseContext.getEntityClass()) != null && Page.class.isAssignableFrom(entityClass)) {
            Page page = (Page)responseContext.getEntity();
            if (page.getResultSize() == 0) {
                if (page.getFirstResult() == 0L) {
                    responseContext.getHeaders().add((Object)"Content-Range", (Object)"records -/0");
                    responseContext.setStatus(HTTP_DATA_COMPLETE);
                } else {
                    responseContext.getHeaders().add((Object)"Content-Range", (Object)("records */" + (page.getTotalResults() < 0L ? "?" : String.valueOf(page.getTotalResults()))));
                    responseContext.setStatus(HTTP_DATA_OUT_OF_RANGE);
                }
            } else {
                responseContext.getHeaders().add((Object)"Content-Range", (Object)new StringBuilder("records ").append(page.getFirstResult()).append('-').append(page.getFirstResult() + (long)page.getResultSize() - 1L).append('/').append(page.getTotalResults() < 0L ? "?" : String.valueOf(page.getTotalResults())));
                responseContext.setStatus(page.getTotalResults() < 0L ? HTTP_DATA_INCOMPLETE : (page.getFirstResult() + (long)page.getResultSize() == page.getTotalResults() ? HTTP_DATA_COMPLETE : HTTP_DATA_INCOMPLETE));
            }
        }
    }
}

