/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.proxy;

import jakarta.ws.rs.WebApplicationException;
import java.net.URISyntaxException;
import org.apache.hc.client5.http.async.methods.SimpleBody;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.Method;
import org.smallmind.nutsnbolts.http.HttpMethod;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.nutsnbolts.util.Pair;
import org.smallmind.nutsnbolts.util.Tuple;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.LoggerManager;
import org.smallmind.web.http.HttpCallback;
import org.smallmind.web.http.HttpClient;
import org.smallmind.web.http.SimpleCallback;
import org.smallmind.web.jersey.proxy.JsonBody;
import org.smallmind.web.json.scaffold.util.JsonCodec;

public class JsonTarget {
    private final HttpHost httpHost;
    private Tuple<String, String> headers;
    private Tuple<String, String> queryParameters;
    private Level level = Level.OFF;
    private String path;

    public JsonTarget(String host) throws URISyntaxException {
        this.httpHost = HttpHost.create((String)host);
    }

    private JsonTarget(HttpHost httpHost, String path) {
        this.httpHost = httpHost;
        this.path = path;
    }

    public JsonTarget path(String path) throws URISyntaxException {
        return new JsonTarget(this.httpHost, path);
    }

    public JsonTarget header(String key, String value) {
        if (this.headers == null) {
            this.headers = new Tuple();
        }
        this.headers.addPair((Object)key, (Object)value);
        return this;
    }

    public JsonTarget query(String key, String value) {
        if (this.queryParameters == null) {
            this.queryParameters = new Tuple();
        }
        this.queryParameters.addPair((Object)key, (Object)value);
        return this;
    }

    public JsonTarget debug(Level level) {
        this.level = level;
        return this;
    }

    public <T> T get(Class<T> responseClass) throws Exception {
        SimpleHttpRequest httpRequest = this.createHttpRequest(HttpMethod.GET, null);
        LoggerManager.getLogger(JsonTarget.class).log(this.level, (Object)new RequestDebugCollector(httpRequest));
        SimpleCallback callback = new SimpleCallback();
        HttpClient.execute((SimpleHttpRequest)httpRequest, (HttpCallback)callback, (int)10);
        return this.convertEntity(callback.getResponse(), responseClass);
    }

    public <T> T put(JsonBody jsonBody, Class<T> responseClass) throws Exception {
        SimpleHttpRequest httpRequest = this.createHttpRequest(HttpMethod.PUT, jsonBody);
        LoggerManager.getLogger(JsonTarget.class).log(this.level, (Object)new RequestDebugCollector(httpRequest));
        SimpleCallback callback = new SimpleCallback();
        HttpClient.execute((SimpleHttpRequest)httpRequest, (HttpCallback)callback, (int)10);
        return this.convertEntity(callback.getResponse(), responseClass);
    }

    public <T> T post(JsonBody jsonBody, Class<T> responseClass) throws Exception {
        SimpleHttpRequest httpRequest = this.createHttpRequest(HttpMethod.POST, jsonBody);
        LoggerManager.getLogger(JsonTarget.class).log(this.level, (Object)new RequestDebugCollector(httpRequest));
        SimpleCallback callback = new SimpleCallback();
        HttpClient.execute((SimpleHttpRequest)httpRequest, (HttpCallback)callback, (int)10);
        return this.convertEntity(callback.getResponse(), responseClass);
    }

    public <T> T patch(JsonBody jsonBody, Class<T> responseClass) throws Exception {
        SimpleHttpRequest httpRequest = this.createHttpRequest(HttpMethod.PATCH, jsonBody);
        LoggerManager.getLogger(JsonTarget.class).log(this.level, (Object)new RequestDebugCollector(httpRequest));
        SimpleCallback callback = new SimpleCallback();
        HttpClient.execute((SimpleHttpRequest)httpRequest, (HttpCallback)callback, (int)10);
        return this.convertEntity(callback.getResponse(), responseClass);
    }

    public <T> T delete(Class<T> responseClass) throws Exception {
        SimpleHttpRequest httpRequest = this.createHttpRequest(HttpMethod.DELETE, null);
        LoggerManager.getLogger(JsonTarget.class).log(this.level, (Object)new RequestDebugCollector(httpRequest));
        SimpleCallback callback = new SimpleCallback();
        HttpClient.execute((SimpleHttpRequest)httpRequest, (HttpCallback)callback, (int)10);
        return this.convertEntity(callback.getResponse(), responseClass);
    }

    private <T> T convertEntity(SimpleHttpResponse response, Class<T> responseClass) {
        byte[] bodyContent;
        SimpleBody body = response.getBody();
        if (body == null || (bodyContent = body.getBodyBytes()) == null || bodyContent.length == 0) {
            if (response.getCode() >= 200 && response.getCode() < 300) {
                return null;
            }
            throw new WebApplicationException(response.getReasonPhrase(), response.getCode());
        }
        LoggerManager.getLogger(JsonTarget.class).log(this.level, (Object)new ResponseDebugCollector(response));
        return (T)JsonCodec.convert((Object)bodyContent, responseClass);
    }

    private SimpleHttpRequest createHttpRequest(HttpMethod httpMethod, JsonBody jsonBody) {
        if (this.queryParameters != null) {
            StringBuilder queryBuilder = new StringBuilder("?");
            boolean first = true;
            for (Pair queryPair : this.queryParameters) {
                if (!first) {
                    queryBuilder.append('&');
                }
                queryBuilder.append((String)queryPair.getFirst()).append('=').append((String)queryPair.getSecond());
                first = false;
            }
            this.path = String.valueOf(this.path) + String.valueOf(queryBuilder);
        }
        SimpleHttpRequest httpRequest = switch (httpMethod) {
            case HttpMethod.GET -> SimpleHttpRequest.create((Method)Method.GET, (HttpHost)this.httpHost, (String)this.path);
            case HttpMethod.PUT -> SimpleHttpRequest.create((Method)Method.PUT, (HttpHost)this.httpHost, (String)this.path);
            case HttpMethod.POST -> SimpleHttpRequest.create((Method)Method.POST, (HttpHost)this.httpHost, (String)this.path);
            case HttpMethod.PATCH -> SimpleHttpRequest.create((Method)Method.PATCH, (HttpHost)this.httpHost, (String)this.path);
            case HttpMethod.DELETE -> SimpleHttpRequest.create((Method)Method.DELETE, (HttpHost)this.httpHost, (String)this.path);
            default -> throw new UnknownSwitchCaseException(httpMethod.name(), new Object[0]);
        };
        if (this.headers != null) {
            for (Pair headerPair : this.headers) {
                httpRequest.addHeader((String)headerPair.getFirst(), headerPair.getSecond());
            }
        }
        if (jsonBody != null) {
            httpRequest.setBody(jsonBody.getBodyAsBytes(), jsonBody.getContentType());
        }
        return httpRequest;
    }

    private static class RequestDebugCollector {
        private final SimpleHttpRequest httpRequest;

        private RequestDebugCollector(SimpleHttpRequest httpRequest) {
            this.httpRequest = httpRequest;
        }

        public String toString() {
            StringBuilder debugBuilder = new StringBuilder();
            debugBuilder.append("Sending client request\n");
            debugBuilder.append("< ").append(this.httpRequest.getRequestUri()).append('\n');
            Header[] headerArray = this.httpRequest.getHeaders();
            int n = headerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                debugBuilder.append("< ").append(header.getName()).append(": ").append(header.getValue()).append('\n');
                ++n2;
            }
            if (this.httpRequest.getBody() != null) {
                debugBuilder.append(this.httpRequest.getBody().getBodyText()).append('\n');
            }
            return debugBuilder.toString();
        }
    }

    private static class ResponseDebugCollector {
        private final SimpleHttpResponse response;

        private ResponseDebugCollector(SimpleHttpResponse response) {
            this.response = response;
        }

        public String toString() {
            StringBuilder debugBuilder = new StringBuilder();
            debugBuilder.append("Receiving client response\n");
            debugBuilder.append("< ").append(this.response.getCode()).append('\n');
            Header[] headerArray = this.response.getHeaders();
            int n = headerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                debugBuilder.append("< ").append(header.getName()).append(": ").append(header.getValue()).append('\n');
                ++n2;
            }
            debugBuilder.append(this.response.getBodyText()).append('\n');
            return debugBuilder.toString();
        }
    }
}

