/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.json;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.smallmind.web.json.scaffold.util.JsonCodec;

@Consumes(value={"application/json", "text/json"})
@Produces(value={"application/json", "text/json"})
public class JsonProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final ThreadLocal<ByteArrayOutputStream> WRITE_BUFFER_LOCAL = new ThreadLocal();

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return JsonCodec.read((InputStream)entityStream, type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public long getSize(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        WRITE_BUFFER_LOCAL.set(new ByteArrayOutputStream());
        try {
            JsonCodec.writeToStream((OutputStream)WRITE_BUFFER_LOCAL.get(), (Object)o);
            return WRITE_BUFFER_LOCAL.get().size();
        }
        catch (Throwable throwable) {
            WRITE_BUFFER_LOCAL.remove();
            throw new WebApplicationException(throwable);
        }
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            if (WRITE_BUFFER_LOCAL.get() == null) {
                this.getSize(o, type, genericType, annotations, mediaType);
            }
            entityStream.write(WRITE_BUFFER_LOCAL.get().toByteArray());
        }
        finally {
            WRITE_BUFFER_LOCAL.remove();
        }
    }
}

