/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.aop;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.lang.reflect.Constructor;
import org.smallmind.nutsnbolts.reflection.type.GenericUtility;
import org.smallmind.web.jersey.aop.JsonEntity;
import org.smallmind.web.jersey.aop.ParameterAnnotations;
import org.smallmind.web.jersey.aop.ParameterProcessingException;
import org.smallmind.web.json.scaffold.util.JsonCodec;

public abstract class AbstractIndexedJsonEntity
implements JsonEntity {
    private static final Class[] NO_ARG_SIGNATURE = new Class[0];
    private Object[] arguments;

    public AbstractIndexedJsonEntity() {
    }

    public AbstractIndexedJsonEntity(Object[] arguments) {
        this.arguments = arguments;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    @Override
    public <T> T getParameter(String key, Class<T> clazz, ParameterAnnotations parameterAnnotations) {
        int index;
        try {
            index = Integer.parseInt(key);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParameterProcessingException(numberFormatException);
        }
        if (index < 0) {
            throw new ParameterProcessingException("Entity argument index must be >= 0", new Object[0]);
        }
        if (index >= this.arguments.length) {
            return null;
        }
        XmlJavaTypeAdapter xmlJavaTypeAdapter = parameterAnnotations.getAnnotation(XmlJavaTypeAdapter.class);
        if (xmlJavaTypeAdapter != null) {
            try {
                Constructor adapterConstructor = xmlJavaTypeAdapter.value().getConstructor(NO_ARG_SIGNATURE);
                if (adapterConstructor == null) {
                    throw new ParameterProcessingException("XmlAdapter of type(%s) must have a no arg constructor", xmlJavaTypeAdapter.value().getName());
                }
                XmlAdapter xmlAdapter = (XmlAdapter)adapterConstructor.newInstance(new Object[0]);
                return (T)JsonCodec.convert((Object)xmlAdapter.unmarshal(JsonCodec.convert((Object)this.arguments[index], (Class)((Class)GenericUtility.getTypeArgumentsOfSubclass(XmlAdapter.class, xmlAdapter.getClass()).get(0)))), clazz);
            }
            catch (Exception exception) {
                throw new ParameterProcessingException(exception);
            }
        }
        return (T)JsonCodec.convert((Object)this.arguments[index], clazz);
    }
}

