/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.api.spring;

import java.text.MessageFormat;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class Smarti18nMessageSource
extends AbstractMessageSource {
    private static final String PATH_MESSAGES_SOURCE = "/api/1/messages/findForSpringMessageSource";
    private final Map<String, Map<Locale, String>> messages;

    public Smarti18nMessageSource() {
        this("default", "default");
    }

    public Smarti18nMessageSource(String projectId, String projectSecret) {
        this("https://messages.smarti18n.com", projectId, projectSecret);
    }

    public Smarti18nMessageSource(String host, String projectId, String projectSecret) {
        Assert.notNull((Object)host, (String)"host");
        Assert.notNull((Object)projectId, (String)"projectId");
        Assert.notNull((Object)projectSecret, (String)"projectSecret");
        this.messages = new HashMap<String, Map<Locale, String>>();
        UpdateMessageSourceTask task = new UpdateMessageSourceTask(host, projectId, projectSecret, this.messages);
        new Timer(true).schedule((TimerTask)task, 0L, 60000L);
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        if (this.messages.containsKey(code)) {
            Map<Locale, String> translations = this.messages.get(code);
            if (translations.containsKey(locale)) {
                return new MessageFormat(translations.get(locale), locale);
            }
            Locale languageLocale = new Locale(locale.getLanguage());
            if (translations.containsKey(languageLocale)) {
                return new MessageFormat(translations.get(languageLocale), languageLocale);
            }
        }
        return new MessageFormat("?" + code + "?");
    }

    private static class UpdateMessageSourceTask
    extends TimerTask {
        private final RestTemplate restTemplate = new RestTemplate();
        private final String host;
        private final String projectId;
        private final String projectSecret;
        private final Map<String, Map<Locale, String>> messages;

        private UpdateMessageSourceTask(String host, String projectId, String projectSecret, Map<String, Map<Locale, String>> messages) {
            this.host = host;
            this.projectId = projectId;
            this.projectSecret = projectSecret;
            this.messages = messages;
        }

        @Override
        public void run() {
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.host).path(Smarti18nMessageSource.PATH_MESSAGES_SOURCE);
            Map messages = (Map)this.restTemplate.exchange(builder.build().encode().toUri(), HttpMethod.GET, new HttpEntity((MultiValueMap)this.headers()), (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Map<Locale, String>>>(){}).getBody();
            this.messages.putAll(messages);
        }

        private HttpHeaders headers() {
            String plainCredentials = this.projectId + ":" + this.projectSecret;
            String base64Credentials = new String(Base64.getEncoder().encode(plainCredentials.getBytes()));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Authorization", "Basic " + base64Credentials);
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            return headers;
        }
    }
}

