/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.api;

import java.util.Collections;
import org.smarti18n.api.ApiException;
import org.smarti18n.api.UserCredentialsSupplier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

abstract class AbstractApiImpl {
    public static final String DEFAULT_HOST = "https://messages.smarti18n.com";
    final RestTemplate restTemplate;
    private final String host;
    private final UserCredentialsSupplier userCredentialsSupplier;

    AbstractApiImpl(RestTemplate restTemplate, String host, UserCredentialsSupplier userCredentialsSupplier) {
        this.restTemplate = restTemplate;
        this.host = host;
        this.userCredentialsSupplier = userCredentialsSupplier;
    }

    AbstractApiImpl(RestTemplate restTemplate, int port, UserCredentialsSupplier userCredentialsSupplier) {
        this.restTemplate = restTemplate;
        this.host = "http://localhost:" + port;
        this.userCredentialsSupplier = userCredentialsSupplier;
    }

    <OUT, IN> OUT post(UriComponentsBuilder uri, IN project, Class<OUT> responseType) {
        ResponseEntity exchange = this.restTemplate.exchange(uri.build().encode().toUri(), HttpMethod.POST, new HttpEntity(project, (MultiValueMap)this.headers()), responseType);
        return this.handleResponse(exchange);
    }

    <OUT> OUT get(UriComponentsBuilder uri, Class<OUT> responseType) {
        ResponseEntity exchange = this.restTemplate.exchange(uri.build().encode().toUri(), HttpMethod.GET, new HttpEntity((MultiValueMap)this.headers()), responseType);
        return this.handleResponse(exchange);
    }

    UriComponentsBuilder uri(String path) {
        return UriComponentsBuilder.fromHttpUrl((String)this.host).path(path);
    }

    UriComponentsBuilder uri(String path, String projectId) {
        return this.uri(path).queryParam("projectId", new Object[]{projectId});
    }

    <OUT> OUT handleResponse(ResponseEntity<OUT> exchange) {
        if (exchange.getStatusCode().isError()) {
            throw new ApiException("SmartI18N Message API: " + exchange.getStatusCode().getReasonPhrase());
        }
        return (OUT)exchange.getBody();
    }

    private HttpHeaders headers() {
        String base64Credentials = this.userCredentialsSupplier.getBase64Credentials();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Basic " + base64Credentials);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        return headers;
    }
}

