/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.api;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.smarti18n.api.Message;

public class MessageImpl
implements Message {
    private String key;
    private Map<Locale, String> translations;

    public MessageImpl() {
        this.translations = new HashMap<Locale, String>();
    }

    public MessageImpl(Message message) {
        this.key = message.getKey();
        this.translations = new HashMap<Locale, String>(message.getTranslations());
    }

    public MessageImpl(String key, Map<Locale, String> translations) {
        this.key = key;
        this.translations = translations;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public Map<Locale, String> getTranslations() {
        return this.translations;
    }

    @Override
    public void setTranslations(Map<Locale, String> translations) {
        this.translations = translations;
    }

    public void putTranslation(Locale value) {
        this.translations.putIfAbsent(value, "");
    }

    public String toString() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageImpl)) {
            return false;
        }
        MessageImpl message = (MessageImpl)o;
        return this.key.equals(message.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

