/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.smarti18n.api.AbstractApiImpl;
import org.smarti18n.api.Message;
import org.smarti18n.api.MessageImpl;
import org.smarti18n.api.MessagesApi;
import org.smarti18n.api.UserCredentialsSupplier;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class MessagesApiImpl
extends AbstractApiImpl
implements MessagesApi {
    public MessagesApiImpl(RestTemplate restTemplate, String host, UserCredentialsSupplier userCredentialsSupplier) {
        super(restTemplate, host, userCredentialsSupplier);
    }

    public MessagesApiImpl(RestTemplate restTemplate, int port, UserCredentialsSupplier userCredentialsSupplier) {
        super(restTemplate, port, userCredentialsSupplier);
    }

    public Collection<MessageImpl> findAll(String projectId) {
        UriComponentsBuilder uri = this.uri("/api/1/messages/findAll", projectId);
        return Arrays.asList((Object[])this.get(uri, MessageImpl[].class));
    }

    @Override
    public Message findOne(String projectId, String key) {
        UriComponentsBuilder uri = this.uri("/api/1/messages/findOne", projectId).queryParam("key", new Object[]{key});
        return this.get(uri, MessageImpl.class);
    }

    @Override
    public MessageImpl insert(String projectId, String key) {
        UriComponentsBuilder uri = this.uri("/api/1/messages/insert", projectId).queryParam("key", new Object[]{key});
        return this.get(uri, MessageImpl.class);
    }

    @Override
    public MessageImpl update(String projectId, String key, Locale locale, String translation) {
        UriComponentsBuilder uri = this.uri("/api/1/messages/update", projectId).queryParam("key", new Object[]{key}).queryParam("translation", new Object[]{translation}).queryParam("locale", new Object[]{locale});
        return this.get(uri, MessageImpl.class);
    }

    @Override
    public MessageImpl copy(String projectId, String sourceKey, String targetKey) {
        UriComponentsBuilder uri = this.uri("/api/1/messages/copy", projectId).queryParam("sourceKey", new Object[]{sourceKey}).queryParam("targetKey", new Object[]{targetKey});
        return this.get(uri, MessageImpl.class);
    }

    @Override
    public void remove(String projectId, String key) {
        UriComponentsBuilder uri = this.uri("/api/1/messages/remove", projectId).queryParam("key", new Object[]{key});
        this.get(uri, Void.class);
    }
}

