/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.api;

import java.util.Base64;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.smarti18n.api.AbstractApiImpl;
import org.smarti18n.api.SpringMessagesApi;
import org.smarti18n.models.UserCredentialsSupplier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class SpringMessagesApiImpl
extends AbstractApiImpl
implements SpringMessagesApi {
    private final String projectId;
    private final String projectSecret;

    SpringMessagesApiImpl(RestTemplate restTemplate, String host, String projectId, String projectSecret) {
        super(restTemplate, host, new UserCredentialsSupplier());
        this.projectId = projectId;
        this.projectSecret = projectSecret;
    }

    public SpringMessagesApiImpl(RestTemplate restTemplate, int port, String projectId, String projectSecret) {
        super(restTemplate, port, new UserCredentialsSupplier());
        this.projectId = projectId;
        this.projectSecret = projectSecret;
    }

    @Override
    public Map<String, Map<Locale, String>> findForSpringMessageSource() {
        UriComponentsBuilder builder = this.uri("/api/1/messages/findForSpringMessageSource");
        String plainCredentials = this.projectId + ":" + this.projectSecret;
        String base64Credentials = new String(Base64.getEncoder().encode(plainCredentials.getBytes()));
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Basic " + base64Credentials);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        ResponseEntity exchange = this.restTemplate.exchange(builder.build().encode().toUri(), HttpMethod.GET, new HttpEntity((MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Map<Locale, String>>>(){});
        return (Map)this.handleResponse(exchange);
    }
}

