/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.api;

import java.util.Arrays;
import java.util.List;
import org.smarti18n.api.AbstractApiImpl;
import org.smarti18n.api.UserApi;
import org.smarti18n.models.User;
import org.smarti18n.models.UserCredentialsSupplier;
import org.smarti18n.models.UserSimplified;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class UserApiImpl
extends AbstractApiImpl
implements UserApi {
    public UserApiImpl(RestTemplate restTemplate, String host, UserCredentialsSupplier userCredentialsSupplier) {
        super(restTemplate, host, userCredentialsSupplier);
    }

    public UserApiImpl(RestTemplate restTemplate, int port, UserCredentialsSupplier userCredentialsSupplier) {
        super(restTemplate, port, userCredentialsSupplier);
    }

    @Override
    public List<User> findAll() {
        UriComponentsBuilder uri = this.uri("/api/1/users/findAll");
        return Arrays.asList((Object[])this.get(uri, User[].class));
    }

    @Override
    public User findOne(String mail) {
        UriComponentsBuilder uri = this.uri("/api/1/users/findOne").queryParam("mail", new Object[]{mail});
        return this.get(uri, User.class);
    }

    @Override
    public UserSimplified findOneSimplified(String mail) {
        UriComponentsBuilder uri = this.uri("/api/1/users/findOneSimplified").queryParam("mail", new Object[]{mail});
        ResponseEntity exchange = this.restTemplate.exchange(uri.build().encode().toUri(), HttpMethod.GET, null, UserSimplified.class);
        return (UserSimplified)this.handleResponse(exchange);
    }

    @Override
    public User register(String mail, String password) {
        UriComponentsBuilder uri = this.uri("/api/1/users/register").queryParam("mail", new Object[]{mail}).queryParam("password", new Object[]{password});
        return this.get(uri, User.class);
    }

    @Override
    public User update(User user) {
        return this.post(this.uri("/api/1/users/update"), user, User.class);
    }
}

