/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.smarti18n.exceptions.ApiException;
import org.smarti18n.models.ApiError;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.ResponseErrorHandler;

public class ApiExceptionHandler
implements ResponseErrorHandler {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public boolean hasError(ClientHttpResponse response) throws IOException {
        return !response.getStatusCode().is2xxSuccessful();
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        String responseBody = IOUtils.toString((InputStream)response.getBody(), (Charset)Charset.defaultCharset());
        ApiError apiError = (ApiError)this.objectMapper.readValue(responseBody, ApiError.class);
        Class<? extends ApiException> exceptionClass = apiError.getExceptionClass();
        try {
            throw exceptionClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }
}

