/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.smarti18n.models.MessageImpl;
import org.springframework.util.StringUtils;

@JsonDeserialize(as=MessageImpl.class)
public interface Message
extends Serializable {
    public String getKey();

    public void setKey(String var1);

    public Map<Locale, String> getTranslations();

    public void setTranslations(Map<Locale, String> var1);

    default public String getTranslation(Locale locale) {
        Map<Locale, String> translations = this.getTranslations();
        if (translations == null) {
            return null;
        }
        return translations.getOrDefault(locale, "");
    }

    default public void setTranslation(Locale locale, String value) {
        Map<Locale, String> translations = this.getTranslations();
        if (translations != null) {
            translations.put(locale, value);
        }
    }

    default public Set<Locale> getLocales() {
        return this.getTranslations().entrySet().stream().filter(localeStringEntry -> !StringUtils.isEmpty(localeStringEntry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    default public String getLocalesAsString() {
        StringBuilder builder = new StringBuilder();
        this.getLocales().forEach(locale -> {
            if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(locale.toString());
        });
        return builder.toString();
    }
}

