/*
 * Decompiled with CFR 0.152.
 */
package de.smartrplace.app.heatcontrol.overview;

import de.iwes.widgets.api.OgemaGuiService;
import de.iwes.widgets.api.widgets.WidgetApp;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.navigation.MenuConfiguration;
import de.iwes.widgets.api.widgets.navigation.NavigationMenu;
import de.smartrplace.app.heatcontrol.overview.HeatControlOverviewController;
import de.smartrplace.app.heatcontrol.overview.gui.MainPage;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.logging.OgemaLogger;
import org.smartrplace.apps.heatcontrol.extensionapi.GUIInitDataProvider;
import org.smartrplace.apps.heatcontrol.extensionapi.HeatControlExtPoint;
import org.smartrplace.apps.heatcontrol.extensionapi.HeatControlExtRoomData;

@Component(specVersion="1.2", immediate=true)
@Service(value={Application.class})
public class HeatControlOverviewApp
implements Application {
    public static final String urlPath = "/org/sp/app/heatoverview";
    private OgemaLogger log;
    private ApplicationManager appMan;
    private HeatControlOverviewController controller;
    private WidgetApp widgetApp;
    @Reference
    private OgemaGuiService guiService;
    @Reference
    public HeatControlExtPoint heatExtPoint;
    public MainPage mainPage;

    public void start(ApplicationManager appManager) {
        this.appMan = appManager;
        this.log = appManager.getLogger();
        this.controller = new HeatControlOverviewController(this.appMan, this);
        this.widgetApp = this.guiService.createWidgetApp(urlPath, appManager);
        WidgetPage page = this.widgetApp.createStartPage();
        HeatControlExtRoomData initData = null;
        if (this.controller.serviceAccess.heatExtPoint instanceof GUIInitDataProvider) {
            initData = (HeatControlExtRoomData)((GUIInitDataProvider)this.controller.serviceAccess.heatExtPoint).getInitObject(HeatControlExtRoomData.class);
        }
        this.mainPage = new MainPage(page, this.controller, initData);
        NavigationMenu menu = new NavigationMenu("Select Page");
        menu.addEntry("Overview Page", page);
        MenuConfiguration mc = page.getMenuConfiguration();
        mc.setCustomNavigation(menu);
    }

    public void stop(Application.AppStopReason reason) {
        if (this.widgetApp != null) {
            this.widgetApp.close();
        }
        if (this.controller != null) {
            this.controller.close();
        }
        this.log.info("{} stopped", (Object)this.getClass().getName());
    }

    protected void bindGuiService(OgemaGuiService ogemaGuiService) {
        this.guiService = ogemaGuiService;
    }

    protected void unbindGuiService(OgemaGuiService ogemaGuiService) {
        if (this.guiService == ogemaGuiService) {
            this.guiService = null;
        }
    }

    protected void bindHeatExtPoint(HeatControlExtPoint heatControlExtPoint) {
        this.heatExtPoint = heatControlExtPoint;
    }

    protected void unbindHeatExtPoint(HeatControlExtPoint heatControlExtPoint) {
        if (this.heatExtPoint == heatControlExtPoint) {
            this.heatExtPoint = null;
        }
    }
}

