/*
 * Decompiled with CFR 0.152.
 */
package de.smartrplace.app.heatcontrol.overview;

import de.smartrplace.app.heatcontrol.overview.HeatControlOverviewApp;
import de.smartrplace.app.heatcontrol.overview.config.HeatcontrolOverviewData;
import de.smartrplace.app.heatcontrol.overview.gui.MainPage;
import java.util.ArrayList;
import java.util.List;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.application.Timer;
import org.ogema.core.application.TimerListener;
import org.ogema.core.logging.OgemaLogger;
import org.ogema.core.model.Resource;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.units.TemperatureResource;
import org.ogema.core.resourcemanager.ResourceValueListener;
import org.ogema.model.devices.buildingtechnology.Thermostat;
import org.ogema.model.locations.Room;
import org.ogema.tools.resource.util.ResourceUtils;
import org.smartrplace.apps.heatcontrol.extensionapi.HeatControlExtPoint;
import org.smartrplace.apps.heatcontrol.extensionapi.HeatControlExtRoomData;

public class HeatControlOverviewController {
    public static final long MANUAL_UPDATE_INTERVAL = 600000L;
    public static final long MIN_BOOST_INTERVAL = 1200000L;
    public static final long MIN_BOOST_BLOCKER = 60000L;
    public static final float MIN_TEMPDIFF = 0.2f;
    public OgemaLogger log;
    public ApplicationManager appMan;
    public final HeatControlOverviewApp serviceAccess;
    public final HeatControlExtPoint extPoint;
    private final RoomListenerOverview roomListener;

    public HeatControlOverviewController(ApplicationManager appMan, HeatControlOverviewApp evaluationOCApp) {
        this.appMan = appMan;
        this.log = appMan.getLogger();
        this.serviceAccess = evaluationOCApp;
        this.extPoint = evaluationOCApp.heatExtPoint;
        this.roomListener = new RoomListenerOverview();
        this.extPoint.registerRoomListener((HeatControlExtPoint.HeatControlExtRoomListener)this.roomListener);
    }

    public void close() {
        this.extPoint.unregisterRoomListener((HeatControlExtPoint.HeatControlExtRoomListener)this.roomListener);
    }

    private void resetManualOperation(HeatControlExtRoomData data) {
        data.setManualTemperatureSetpoint(0.0f, -1L);
    }

    public void startBoost(HeatControlExtRoomData object) {
        RoomControlled rc = this.roomListener.getRoomData(object.getRoom());
        rc.startBoost();
    }

    class RoomListenerOverview
    implements HeatControlExtPoint.HeatControlExtRoomListener {
        public List<RoomControlled> roomsControlled = new ArrayList<RoomControlled>();

        RoomListenerOverview() {
        }

        public RoomControlled getRoomData(Room room) {
            for (RoomControlled r : this.roomsControlled) {
                if (!r.data.getRoom().equalsLocation((Resource)room)) continue;
                return r;
            }
            return null;
        }

        public void roomAvailable(HeatControlExtRoomData roomData, HeatControlExtPoint.HeatControlExtRoomListener.CallbackReason reason) {
            if (reason == HeatControlExtPoint.HeatControlExtRoomListener.CallbackReason.UPDATE) {
                RoomControlled old = this.getRoomData(roomData.getRoom());
                old.updateData(roomData);
                old.initThermostats();
            } else {
                RoomControlled r = new RoomControlled(roomData);
                this.roomsControlled.add(r);
            }
        }

        public void roomUnavailable(HeatControlExtRoomData roomData, HeatControlExtPoint.HeatControlExtRoomListener.CallbackReason reason) {
            RoomControlled old = this.getRoomData(roomData.getRoom());
            if (old != null) {
                HeatControlOverviewController.this.resetManualOperation(roomData);
                old.close();
                this.roomsControlled.remove(old);
            }
        }
    }

    class RoomControlled
    implements TimerListener {
        private HeatControlExtRoomData data;
        HeatcontrolOverviewData myData;
        List<TemperatureResource> timerBasedManualSetters = null;
        List<ResourceValueListener<IntegerResource>> hmModeListeners = new ArrayList<ResourceValueListener<IntegerResource>>();
        List<ResourceValueListener<IntegerResource>> myModeListeners = new ArrayList<ResourceValueListener<IntegerResource>>();
        Timer timer = null;
        long lastBoostStarted = -1L;

        public RoomControlled(HeatControlExtRoomData data) {
            this.data = data;
            this.myData = (HeatcontrolOverviewData)data.getRoomExtensionData(true, HeatcontrolOverviewData.class);
            if (Float.isNaN(this.myData.comfortTemperature().getCelsius()) || this.myData.comfortTemperature().getCelsius() < 4.0f || this.myData.comfortTemperature().getCelsius() > 30.0f) {
                this.myData.comfortTemperature().create();
                this.myData.comfortTemperature().setCelsius(21.0f);
            }
            if (!this.myData.controlManualMode().isActive()) {
                this.myData.controlManualMode().create();
                this.myData.controlManualMode().setValue(0);
                this.myData.controlManualMode().activate(false);
            }
            ResourceValueListener<IntegerResource> l = new ResourceValueListener<IntegerResource>(){

                public void resourceChanged(IntegerResource resource) {
                    RoomControlled.this.closeThermostats();
                    RoomControlled.this.initThermostats();
                }
            };
            this.myModeListeners.add(l);
            this.myData.controlManualMode().addValueListener((ResourceValueListener)l, false);
            this.initThermostats();
        }

        private void initThermostats() {
            System.out.println("HeatControlOverview: initThermostats in " + ResourceUtils.getHumanReadableName((Resource)this.data.getRoom()));
            for (Thermostat th : this.data.getThermostats()) {
                IntegerResource modeFB;
                System.out.println("HeatControlOverview: initThermostat mode:" + this.myData.controlManualMode().getValue() + " loc: " + th.getLocation());
                if (this.myData.controlManualMode().getValue() < 1) continue;
                TemperatureResource manualControl = MainPage.getActiveManualModeControl(th);
                if (manualControl != null) {
                    manualControl.setValue(this.data.getCurrentTemperatureSetpoint());
                }
                if ((modeFB = MainPage.getActiveModeFeedback(th)) != null) {
                    ResourceValueListener<IntegerResource> l = new ResourceValueListener<IntegerResource>(){

                        public void resourceChanged(IntegerResource resource) {
                            if (modeFB.getValue() != 1 && modeFB.getValue() != 3) {
                                RoomControlled.this.detectedManualEvent();
                            }
                        }
                    };
                    this.hmModeListeners.add(l);
                    modeFB.addValueListener((ResourceValueListener)l, true);
                    System.out.println("HeatControlOverview: Listening for " + modeFB.getLocation() + " in " + ResourceUtils.getHumanReadableName((Resource)this.data.getRoom()));
                } else {
                    if (this.timerBasedManualSetters == null) {
                        this.timerBasedManualSetters = new ArrayList<TemperatureResource>();
                    }
                    this.timerBasedManualSetters.add(manualControl);
                }
                if (this.timerBasedManualSetters == null) continue;
                this.timer = HeatControlOverviewController.this.appMan.createTimer(600000L, (TimerListener)this);
            }
        }

        private void closeThermostats() {
            for (Thermostat th : this.data.getThermostats()) {
                IntegerResource modeFB = MainPage.getActiveModeFeedback(th);
                if (modeFB != null) {
                    for (ResourceValueListener<IntegerResource> ml : this.hmModeListeners) {
                        modeFB.removeValueListener(ml);
                    }
                }
                if (this.timer == null) continue;
                this.timer.destroy();
            }
        }

        void close() {
            this.closeThermostats();
        }

        public void timerElapsed(Timer timer) {
            for (TemperatureResource manSet : this.timerBasedManualSetters) {
                manSet.setValue(this.data.getCurrentTemperatureSetpoint());
            }
        }

        private void detectedManualEvent() {
            if (HeatControlOverviewController.this.appMan.getFrameworkTime() - this.lastBoostStarted < 60000L) {
                System.out.println("HeatControlOverview: Still blocked by boost for " + (60000L - (HeatControlOverviewController.this.appMan.getFrameworkTime() - this.lastBoostStarted)) / 1000L + " seconds.");
                return;
            }
            boolean lastBoostStartLongAgo = HeatControlOverviewController.this.appMan.getFrameworkTime() - this.lastBoostStarted > 1200000L;
            System.out.println("HeatControlOverview: Detected manual event for " + ResourceUtils.getHumanReadableName((Resource)this.data.getRoom()) + " mode:" + this.myData.controlManualMode().getValue());
            for (Thermostat th : this.data.getThermostats()) {
                TemperatureResource manualControl = MainPage.getActiveManualModeControl(th);
                if (manualControl == null) continue;
                if (this.myData.controlManualMode().getValue() < 2) {
                    manualControl.setValue(this.data.getCurrentTemperatureSetpoint());
                    continue;
                }
                float curDiff = Math.abs(this.data.getCurrentTemperatureSetpoint() - this.myData.comfortTemperature().getValue());
                if (this.myData.controlManualMode().getValue() == 3 && curDiff >= 0.2f && lastBoostStartLongAgo && this.startBoost(th)) continue;
                if (curDiff < 0.2f) {
                    manualControl.setValue(this.data.getCurrentTemperatureSetpoint());
                    HeatControlOverviewController.this.resetManualOperation(this.data);
                    System.out.println("HeatControlOverview: Switched manuel OFF with setpoint " + this.data.getCurrentTemperatureSetpoint());
                    continue;
                }
                manualControl.setValue(this.myData.comfortTemperature().getValue());
                this.data.setManualTemperatureSetpoint(this.myData.comfortTemperature().getValue(), this.data.getAtThermostatManualSettingDuration());
                System.out.println("HeatControlOverview: Set to comfort temp:" + this.myData.comfortTemperature().getValue() + " for " + this.data.getAtThermostatManualSettingDuration());
            }
        }

        public void updateData(HeatControlExtRoomData roomData) {
            this.data = roomData;
        }

        public void startBoost() {
            if (HeatControlOverviewController.this.appMan.getFrameworkTime() - this.lastBoostStarted < 60000L) {
                System.out.println("HeatControlOverview: Still blocked by boost for " + (60000L - (HeatControlOverviewController.this.appMan.getFrameworkTime() - this.lastBoostStarted)) / 1000L + " seconds.");
                return;
            }
            for (Thermostat th : this.data.getThermostats()) {
                this.startBoost(th);
            }
        }

        private boolean startBoost(Thermostat th) {
            BooleanResource boostControl = MainPage.getBoostControl(th);
            if (boostControl != null) {
                boostControl.setValue(true);
                this.lastBoostStarted = HeatControlOverviewController.this.appMan.getFrameworkTime();
                System.out.println("HeatControlOverview: Started boost");
                return true;
            }
            return false;
        }
    }
}

