/*
 * Decompiled with CFR 0.152.
 */
package de.smartrplace.app.heatcontrol.overview.gui;

import de.iwes.util.format.StringFormatHelper;
import de.iwes.widgets.api.extended.WidgetData;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.html.HtmlItem;
import de.iwes.widgets.api.widgets.html.StaticTable;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.html.form.button.Button;
import de.iwes.widgets.html.form.checkbox.SimpleCheckbox;
import de.iwes.widgets.html.form.label.Header;
import de.iwes.widgets.html.form.label.Label;
import de.iwes.widgets.resource.widget.textfield.ValueResourceTextField;
import de.smartrplace.app.heatcontrol.common.util.RoomDataUtil;
import de.smartrplace.app.heatcontrol.overview.HeatControlOverviewController;
import de.smartrplace.app.heatcontrol.overview.config.GlobalHeatcontrolOverviewData;
import de.smartrplace.app.heatcontrol.overview.config.HeatcontrolOverviewData;
import de.smartrplace.app.heatcontrol.overview.gui.ServiceValueEdit;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.Resource;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.core.model.simple.TimeResource;
import org.ogema.core.model.units.TemperatureResource;
import org.ogema.model.devices.buildingtechnology.Thermostat;
import org.ogema.model.locations.Room;
import org.ogema.tools.resource.util.ResourceUtils;
import org.smartrplace.apps.heatcontrol.extensionapi.HeatControlExtPoint;
import org.smartrplace.apps.heatcontrol.extensionapi.HeatControlExtRoomData;
import org.smartrplace.util.directobjectgui.ObjectGUITablePage;
import org.smartrplace.util.directobjectgui.ObjectResourceGUIHelper;
import org.smartrplace.util.format.ValueFormat;
import org.smartrplace.util.format.WidgetHelper;

public class MainPage
extends ObjectGUITablePage<HeatControlExtRoomData, Room> {
    public static final float MIN_COMFORT_TEMP = 4.0f;
    public static final float MAX_COMFORT_TEMP = 30.0f;
    public static final float DEFAULT_COMFORT_TEMP = 21.0f;
    private final HeatControlExtPoint heatExtPoint;
    private final GlobalHeatcontrolOverviewData myGlobalData;
    private final HeatControlOverviewController app;
    ValueResourceTextField<TimeResource> updateInterval;

    public MainPage(WidgetPage<?> page, HeatControlOverviewController app, HeatControlExtRoomData initData) {
        super(page, app.appMan, (Object)initData);
        this.app = app;
        this.heatExtPoint = app.serviceAccess.heatExtPoint;
        this.myGlobalData = (GlobalHeatcontrolOverviewData)this.heatExtPoint.extensionData(true, GlobalHeatcontrolOverviewData.class);
    }

    public void addWidgetsAboveTable() {
        Header header = new Header(this.page, "header", "Heat Control Overview");
        header.addDefaultStyle(WidgetData.TEXT_ALIGNMENT_LEFT);
        this.page.append((OgemaWidget)header);
        SimpleCheckbox ecoModeCheck = new SimpleCheckbox(this.page, "ecoModeCheck", "Eco-Modus"){
            private static final long serialVersionUID = 4762334737747120383L;

            public void onGET(OgemaHttpRequest req) {
                this.setValue(MainPage.this.heatExtPoint.getEcoModeState(), req);
            }

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                MainPage.this.heatExtPoint.setEcoModeState(this.getValue(req));
            }
        };
        this.updateInterval = new ValueResourceTextField<TimeResource>(this.page, "updateInterval"){
            private static final long serialVersionUID = 1L;

            public void onGET(OgemaHttpRequest req) {
                this.selectItem((Resource)MainPage.this.myGlobalData.updateRate(), req);
            }
        };
        StaticTable topTable = new StaticTable(1, 3);
        topTable.setContent(0, 0, (OgemaWidget)ecoModeCheck).setContent(0, 1, "Update Rate (minutes):").setContent(0, 2, this.updateInterval);
        this.page.append((HtmlItem)topTable);
    }

    public Collection<HeatControlExtRoomData> getObjectsInTable(OgemaHttpRequest req) {
        List providers = this.heatExtPoint.getRoomsControlled();
        return providers;
    }

    public void addWidgets(final HeatControlExtRoomData object, ObjectResourceGUIHelper<HeatControlExtRoomData, Room> vh, String id, OgemaHttpRequest req, RowTemplate.Row row, ApplicationManager appMan) {
        HeatcontrolOverviewData configRes = (HeatcontrolOverviewData)object.getRoomExtensionData(true, HeatcontrolOverviewData.class);
        if (object.getRoom() == null) {
            return;
        }
        String roomName = req != null ? ResourceUtils.getHumanReadableShortName((Resource)object.getRoom()) : "";
        Label sl = vh.stringLabel("Room name", id, roomName, row);
        if (configRes != null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (sl != null) {
            System.out.println("Room name " + ResourceUtils.getHumanReadableShortName((Resource)object.getRoom()) + " in " + sl.getId());
        } else {
            System.out.println("Room name for " + id);
        }
        if (object.getThermostats() != null) {
            int thDif = object.getRoomTemperatureSensors().size() - object.getRoomHumiditySensors().size();
            String addSymbol = "";
            if (thDif > 0) {
                addSymbol = "-";
            } else if (thDif < 0) {
                addSymbol = "+";
            }
            String text = "" + object.getThermostats().size() + " / " + object.getRoomTemperatureSensors().size() + addSymbol + " / " + object.getWindowSensors().size();
            sl = vh.stringLabel("Therm/TH/Win", id, text, row);
            String columnId = ResourceUtils.getValidResourceName((String)"T/Setp/Valve/H/Open/Motion/Manu");
            String widgetId = columnId + id;
            Label dataLabel = new Label(vh.getParent(), widgetId, req){
                private static final long serialVersionUID = 4515005761380513466L;

                public void onGET(OgemaHttpRequest req) {
                    long remaining = object.getRemainingDirectThermostatManualDuration();
                    if (remaining > 0L && remaining < 1000L) {
                        remaining *= 60000L;
                    }
                    String text = ValueFormat.celsius((float)RoomDataUtil.getRoomTemperatureMeasurement(object.getRoomTemperatureSensors(), object.getThermostats()), (int)1) + " / " + ValueFormat.celsius((float)object.getCurrentTemperatureSetpoint()) + " / " + ValueFormat.floatVal((float)RoomDataUtil.getTotalValveOpening(object.getThermostats()), (String)"%.2f") + " / " + ValueFormat.humidity((float)RoomDataUtil.getAverageRoomHumditiyMeasurement(object.getRoomHumiditySensors())) + " / " + RoomDataUtil.getNumberOpenWindows(object.getWindowSensors()) + " / " + (object.isUserPresent() ? "1" : "0") + " / " + MainPage.getFormattedDurationValue(remaining, 300);
                    this.setText(text, req);
                }
            };
            if (this.myGlobalData.updateRate().getValue() > 0L) {
                dataLabel.setPollingInterval(this.myGlobalData.updateRate().getValue(), req);
            }
            row.addCell(columnId, (Object)dataLabel);
        } else {
            vh.registerHeaderEntry("Therm/TH/Win");
            vh.registerHeaderEntry("T/Setp/Valve/H/Open/Motion/Manu");
        }
        if (configRes != null) {
            vh.floatEdit("Comfort Temp.", id, (FloatResource)configRes.comfortTemperature(), row, this.alert, 4.0f, 30.0f, "Value not allowed");
        } else {
            vh.registerHeaderEntry("Comfort Temp.");
        }
        new ServiceValueEdit("At-Thermostat Duration", id, row, this.alert, 0.0f, 99999.0f, "Value not allowed", vh){

            @Override
            protected String getValue(OgemaHttpRequest req) {
                return object.getAtThermostatManualSettingDuration() / 60000L + " min";
            }

            @Override
            protected void setValue(float value, OgemaHttpRequest req) {
                object.setAtThermostatManualSettingDuration((long)(value * 60000.0f));
            }
        };
        if (object.getThermostats() != null) {
            boolean hasManualModeControl = false;
            boolean allManualModeControl = true;
            boolean hasModeFeedback = false;
            boolean allModeFeedback = true;
            boolean hasBoostMode = false;
            boolean allBoostMode = true;
            for (Thermostat th : object.getThermostats()) {
                if (MainPage.getActiveManualModeControl(th) != null) {
                    hasManualModeControl = true;
                } else {
                    allManualModeControl = false;
                }
                if (MainPage.getActiveModeFeedback(th) != null) {
                    hasModeFeedback = true;
                } else {
                    allModeFeedback = false;
                }
                if (MainPage.getBoostControl(th) != null) {
                    hasBoostMode = true;
                    continue;
                }
                allBoostMode = false;
            }
            if (hasManualModeControl) {
                String adder = "";
                if (hasManualModeControl && !allManualModeControl) {
                    adder = "*";
                }
                HashMap<String, String> valuesToSet = new HashMap<String, String>();
                valuesToSet.put("0", "No control" + adder);
                valuesToSet.put("1", "Set Manual" + adder);
                if (hasModeFeedback) {
                    String adderFB = "";
                    if (!allModeFeedback) {
                        adderFB = "!!";
                    }
                    valuesToSet.put("2", "Thermostat button switch detection" + adderFB + adder);
                }
                vh.dropdown("Control Mode", id, (SingleValueResource)configRes.controlManualMode(), row, valuesToSet);
            } else {
                vh.stringLabel("Control Mode", id, "Control Mode not supported", row);
            }
            if (hasBoostMode) {
                Button boostButton = new Button(vh.getParent(), "boostButton" + id, "Boost->CT" + (allBoostMode ? "" : "*"), req){
                    private static final long serialVersionUID = 2903972124650772289L;

                    public void onPOSTComplete(String data, OgemaHttpRequest req) {
                        MainPage.this.app.startBoost(object);
                    }
                };
                row.addCell("Boost", (Object)boostButton);
            } else {
                vh.stringLabel("Boost", id, "Boost not supported", row);
            }
        } else {
            vh.registerHeaderEntry("Control Mode");
            vh.registerHeaderEntry("Boost");
        }
    }

    public String getLineId(HeatControlExtRoomData object) {
        String roomName = WidgetHelper.getValidWidgetId((String)ResourceUtils.getHumanReadableShortName((Resource)object.getRoom()));
        return roomName + super.getLineId((Object)object);
    }

    public static TemperatureResource getActiveManualModeControl(Thermostat th) {
        TemperatureResource setManualMode = (TemperatureResource)th.getSubResource("setManuMode", TemperatureResource.class);
        if (setManualMode != null && setManualMode.isActive()) {
            return setManualMode;
        }
        return null;
    }

    public static IntegerResource getActiveModeFeedback(Thermostat th) {
        IntegerResource setManualMode = (IntegerResource)th.getSubResource("controlMode", IntegerResource.class);
        if (setManualMode != null && setManualMode.isActive()) {
            return setManualMode;
        }
        return null;
    }

    public static BooleanResource getBoostControl(Thermostat th) {
        BooleanResource setBoostMode = (BooleanResource)th.getSubResource("setBoostMode", BooleanResource.class);
        if (setBoostMode != null && setBoostMode.isActive()) {
            return setBoostMode;
        }
        return null;
    }

    public Room getResource(HeatControlExtRoomData object, OgemaHttpRequest req) {
        return object.getRoom();
    }

    public static String getFormattedDurationValue(long deltaT, int maxMinutesSecond) {
        if (deltaT < 0L) {
            return "--";
        }
        if ((deltaT /= 1000L) < (long)maxMinutesSecond) {
            return String.format("%d sec", deltaT);
        }
        if ((deltaT /= 60L) < (long)maxMinutesSecond) {
            return String.format("%d min", deltaT);
        }
        return StringFormatHelper.getFormattedValue((long)deltaT);
    }

    public static abstract class ResourceWidgetAdder<R extends Resource> {
        public ResourceWidgetAdder(Resource parent, String subResourceName, Class<R> resourceType, String widgetName, ObjectResourceGUIHelper<HeatControlExtRoomData, Room> vh) {
            if (parent == null || subResourceName == null) {
                vh.registerHeaderEntry(widgetName);
                return;
            }
            Resource resource = parent.getSubResource(subResourceName, resourceType);
            if (resource == null || !resource.isActive()) {
                return;
            }
            this.addWidget(resource, widgetName);
        }

        protected abstract void addWidget(R var1, String var2);
    }
}

