/*
 * Decompiled with CFR 0.152.
 */
package de.smartrplace.app.heatcontrol.overview.gui;

import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.html.form.textfield.TextField;
import org.ogema.tools.resource.util.ResourceUtils;
import org.smartrplace.util.directobjectgui.ObjectResourceGUIHelper;

public abstract class ServiceValueEdit {
    private TextField textFieldWidget;

    protected abstract String getValue(OgemaHttpRequest var1);

    protected abstract void setValue(float var1, OgemaHttpRequest var2);

    public ServiceValueEdit(String columnName, String lineId, RowTemplate.Row row, final Alert alert, final float minimumAllowed, final float maximumAllowed, String notAllowedMessage, ObjectResourceGUIHelper<?, ?> vh) {
        if (vh.checkLineId(columnName)) {
            return;
        }
        final String notAllowedMessageUsed = notAllowedMessage == null ? "Value not Allowed!" : notAllowedMessage;
        OgemaHttpRequest req = vh.getReq();
        OgemaWidget parent = vh.getParent();
        String columnId = ResourceUtils.getValidResourceName((String)columnName);
        String widgetId = columnId + lineId;
        this.textFieldWidget = new TextField(parent, widgetId, req){
            private static final long serialVersionUID = 1L;

            public void onGET(OgemaHttpRequest req) {
                String value = ServiceValueEdit.this.getValue(req);
                this.setValue(value, req);
            }

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                float value;
                String val = this.getValue(req);
                try {
                    value = Float.parseFloat(val);
                }
                catch (NullPointerException | NumberFormatException e) {
                    if (alert != null) {
                        alert.showAlert(notAllowedMessageUsed, false, req);
                    }
                    return;
                }
                if (value < minimumAllowed) {
                    if (alert != null) {
                        alert.showAlert(notAllowedMessageUsed, false, req);
                    }
                    return;
                }
                if (value > maximumAllowed) {
                    if (alert != null) {
                        alert.showAlert(notAllowedMessageUsed, false, req);
                    }
                    return;
                }
                ServiceValueEdit.this.setValue(value, req);
                if (alert != null) {
                    alert.showAlert("New value: " + value, true, req);
                }
            }
        };
        row.addCell(columnId, (Object)this.textFieldWidget);
    }

    public TextField getWidget() {
        return this.textFieldWidget;
    }
}

