package org.smartrplace.smarteff.access.api;

import de.iwes.widgets.template.LabelledItem;

public interface GenericPageConfigurationProvider extends LabelledItem {
	public final static String SMARTREFF_URL_BASEPATH = "/org/sp/smarteff/";

	/**The id of the configurationProvider must be provided as parameter
	 * configProvider with URL
	 */
	String id();
	
	/** Get configuration for specific session
	 * 
	 * @param configurationId paramter configurationId provided with URL. If the parameter is null
	 * 		a standard session configuration for the provider may be returned, but in this case
	 * 		also just null be returned, but no exception should be thrown.
	 * @return
	 */
	ConfigInfoExt getSessionConfiguration(String configurationId);
	
	/** Current selections/configurations sent to the provider. The provider can
	 * save these configurations fully or partially or just ignore this information. The
	 * message is generated by the ScheduleViewer when a "Save Configuration" button is pressed.
	 */
	void saveCurrentConfiguration(ConfigInfoExt currentConfiguration, String configurationId);

}
