/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.os.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.ogema.core.application.ApplicationManager;

public class ExecUtils {
    private static String checkExeOrCmd(String shortProgramName, String envPath) {
        Path p = Paths.get(envPath, shortProgramName + ".cmd");
        if (!Files.exists(p, new LinkOption[0])) {
            p = Paths.get(envPath, shortProgramName + ".exe");
        }
        return p.toAbsolutePath().toString();
    }

    public static int executeOnShellBlocking(String cmd, ApplicationManager appMan, int maxSeconds) {
        String[] cmdArr = new String[]{"/bin/sh", "-c", cmd};
        String os = System.getProperty("os.name");
        if (os.toLowerCase().contains("windows")) {
            appMan.getLogger().info("On Linux on shell: " + cmd);
            return -1;
        }
        return ExecUtils.exceuteBlocking(cmdArr, appMan, maxSeconds, false);
    }

    public static int exceuteBlocking(String cmd, ApplicationManager appMan, int maxSeconds, String envForPath) {
        int i;
        String envPath = System.getenv(envForPath);
        String os = System.getProperty("os.name");
        cmd = os.toLowerCase().contains("windows") ? ((i = cmd.indexOf(32)) < 0 ? ExecUtils.checkExeOrCmd(cmd, envPath) : ExecUtils.checkExeOrCmd(cmd.substring(0, i), envPath) + cmd.substring(i)) : (envPath.endsWith("\\") || envPath.endsWith("/") ? envPath + cmd : envPath + File.separator + cmd);
        String[] strArr = new String[]{cmd};
        return ExecUtils.exceuteBlocking(strArr, appMan, maxSeconds, true);
    }

    public static int exceuteBlocking(String[] cmd, ApplicationManager appMan, int maxSeconds, boolean passSingleLine) {
        Process p;
        System.out.println("Executing command: " + cmd);
        try {
            p = passSingleLine ? Runtime.getRuntime().exec(cmd[0]) : Runtime.getRuntime().exec(cmd);
            InputStream in = p.getInputStream();
            int counter = 0;
            while (p.isAlive()) {
                System.out.println("In isAlive: " + cmd);
                Thread.sleep(1000L);
                if (!p.isAlive()) break;
                if (counter > maxSeconds) {
                    System.out.println("Destroy: " + cmd);
                    p.destroy();
                    break;
                }
                ++counter;
            }
            byte[] bbuffer = new byte[4096];
            int readNum = 0;
            try {
                if (in.available() > 0) {
                    readNum = in.read(bbuffer, 0, bbuffer.length - 1);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (readNum >= 0) {
                bbuffer[readNum] = 0;
            } else {
                bbuffer[0] = 0;
            }
            appMan.getLogger().info("Finished Exec with code:" + p.exitValue() + " outStream(" + readNum + ") " + new String(bbuffer));
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return -1;
        }
        return p.exitValue();
    }
}

