/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.os.util;

import java.io.File;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.ogema.core.application.ApplicationManager;
import org.smartrplace.os.util.SendFileUntilSuccess;
import org.smartrplace.os.util.SendFileUntilSuccessListener;

public class FileUploadUtil {
    public static final String UPLOAD_SERVER_PROPERTY = "org.smartrplace.tools.upload.servlet.url";
    public static final String UPLOAD_SERVLET_PROPERTY = "org.smartrplace.tools.upload.servlet.path";
    public static final String UPLOAD_INTERVAL_PROPERTY = "org.smartrplace.tools.upload.interval";
    public static final String UPLOAD_REMOTE_USER_PROPERTY = "org.smartrplace.tools.upload.remote.machine.user";
    public static final String UPLOAD_REMOTE_PW_PROPERTY = "org.smartrplace.tools.upload.remote.machine.user.pw";
    public static final String UPLOAD_SERVLET;
    public static final long UPDATE_INTERVAL;
    public static final String REMOTE_USER;
    public static final String REMOTE_PW;
    private static final SecureRandom random;
    private static final KeyManager[] km;
    private static final TrustManager[] tm;

    public static int sendSimpleDirectory(Path path, String remotePath, String remoteUser, String remotePw, String serverPortAddress, ApplicationManager am, SendFileUntilSuccessListener listener) {
        Collection files2zip = FileUtils.listFiles((File)path.toFile(), null, (boolean)true);
        int retval = 0;
        for (File f : files2zip) {
            SendFileUntilSuccess task = new SendFileUntilSuccess(f.toPath(), remotePath, serverPortAddress, remoteUser, remotePw, am, listener);
            int st = task.getStatus();
            if (st == 0 || st == 500) continue;
            ++retval;
        }
        return retval;
    }

    public static int sendFile(Path path, String remotePath, String remoteUser, String remotePw, String serverPortAddress, ApplicationManager am) {
        try {
            return FileUploadUtil.upload(path, remotePath, remoteUser, remotePw, serverPortAddress, am);
        }
        catch (HttpHostConnectException e) {
            am.getLogger().warn(e.getMessage());
            am.getLogger().debug("Exception detail:", (Throwable)e);
            return -2;
        }
        catch (NoRouteToHostException | UnknownHostException e) {
            am.getLogger().warn(e.getMessage());
            am.getLogger().debug("Exception detail:", (Throwable)e);
            return -3;
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            am.getLogger().warn(e.getMessage());
            am.getLogger().debug("Exception detail:", (Throwable)e);
            return -1;
        }
    }

    public static int upload(Path path, String remotePath, String remoteUser, String remotePw, String serverPortAddress, ApplicationManager am) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        if (remoteUser == null) {
            remoteUser = REMOTE_USER;
        }
        if (remotePw == null) {
            remotePw = REMOTE_PW;
        }
        if (serverPortAddress == null) {
            serverPortAddress = UPLOAD_SERVLET;
        }
        if (serverPortAddress.endsWith("/")) {
            serverPortAddress = serverPortAddress.substring(0, serverPortAddress.length() - 1);
        }
        Path parent = path.getParent();
        String pathInfo = remotePath == null ? (parent != null ? "/" + parent.toString().replace("\\", "/") : "") : remotePath.replace("\\", "/");
        StringBuilder address = new StringBuilder();
        address.append(serverPortAddress);
        if (!pathInfo.isEmpty() && !pathInfo.startsWith("/")) {
            address.append('/');
        }
        address.append(pathInfo).append("?user=").append(remoteUser).append("&pw=").append(remotePw);
        HttpPost post = new HttpPost(address.toString());
        am.getLogger().debug("Sending POST to {}, file {}", (Object)address, (Object)path);
        FileBody fileBody = new FileBody(path.toFile(), ContentType.APPLICATION_OCTET_STREAM);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addPart("file", (ContentBody)fileBody);
        HttpEntity entity = builder.build();
        CloseableHttpClient client = FileUploadUtil.getClient();
        post.setEntity(entity);
        CloseableHttpResponse response = client.execute((HttpUriRequest)post);
        StatusLine sl = response.getStatusLine();
        int sc = sl.getStatusCode();
        if (sc < 300) {
            am.getLogger().debug("Upload response: {}", (Object)sc);
            return 0;
        }
        am.getLogger().info("Upload response: {}, reason {}, address {}", new Object[]{sc, sl.getReasonPhrase(), address});
        return sc;
    }

    private static CloseableHttpClient getClient() throws KeyManagementException, NoSuchAlgorithmException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<CloseableHttpClient>(){

                @Override
                public CloseableHttpClient run() throws Exception {
                    return HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setSSLContext(FileUploadUtil.getSSLContext()).build();
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof KeyManagementException) {
                throw (KeyManagementException)cause;
            }
            if (cause instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private static SSLContext getSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(km, tm, random);
        return ctx;
    }

    static {
        UPDATE_INTERVAL = AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return Long.getLong(FileUploadUtil.UPLOAD_INTERVAL_PROPERTY, 86400000L);
            }
        });
        REMOTE_USER = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(FileUploadUtil.UPLOAD_REMOTE_USER_PROPERTY, "rest");
            }
        });
        REMOTE_PW = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(FileUploadUtil.UPLOAD_REMOTE_PW_PROPERTY, "rest");
            }
        });
        UPLOAD_SERVLET = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String servlet;
                String server = System.getProperty(FileUploadUtil.UPLOAD_SERVER_PROPERTY, "https://localhost:8444");
                if (server.endsWith("/")) {
                    server = server.substring(0, server.length() - 1);
                }
                if (!(servlet = System.getProperty(FileUploadUtil.UPLOAD_SERVLET_PROPERTY, "/org/smartrplace/tools/upload/servlet")).startsWith("/")) {
                    servlet = "/" + servlet;
                }
                if (servlet.endsWith("/")) {
                    servlet = servlet.substring(0, servlet.length() - 1);
                }
                return server + servlet;
            }
        });
        random = new SecureRandom();
        km = new KeyManager[]{new X509KeyManager(){

            @Override
            public String[] getServerAliases(String keyType, Principal[] issuers) {
                return null;
            }

            @Override
            public PrivateKey getPrivateKey(String alias) {
                return null;
            }

            @Override
            public String[] getClientAliases(String keyType, Principal[] issuers) {
                return null;
            }

            @Override
            public X509Certificate[] getCertificateChain(String alias) {
                return null;
            }

            @Override
            public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
                return null;
            }

            @Override
            public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
                return "client";
            }
        }};
        tm = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                throw new CertificateException("not supported");
            }
        }};
    }
}

