/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.tissue.util.resource;

import de.iwes.util.logconfig.LogHelper;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.Resource;
import org.ogema.model.locations.Location;
import org.ogema.model.prototypes.PhysicalElement;
import org.ogema.tools.resource.util.ResourceUtils;
import org.slf4j.LoggerFactory;
import org.smartrplace.tissue.util.resource.UtilExtendedApp;

public class ResourceHelperSP {
    public static DeviceInfo getDeviceInformation(Resource subResource) {
        return ResourceHelperSP.getDeviceInformation(subResource, true);
    }

    public static DeviceInfo getDeviceInformation(final Resource subResource, final boolean locationRelevant) {
        return AccessController.doPrivileged(new PrivilegedAction<DeviceInfo>(){

            @Override
            public DeviceInfo run() {
                Resource inputResourceToUse;
                ApplicationManager appManPriv = UtilExtendedApp.getApplicationManager();
                if (appManPriv != null) {
                    inputResourceToUse = appManPriv.getResourceAccess().getResource(subResource.getPath());
                } else {
                    inputResourceToUse = subResource;
                    LoggerFactory.getLogger((String)"UtilExtended").warn("Could not use Application Manager of util-extended for resource permissions");
                }
                PhysicalElement device = LogHelper.getDeviceResource((Resource)inputResourceToUse, (boolean)locationRelevant);
                if (device == null) {
                    return null;
                }
                DeviceInfo result = new DeviceInfo();
                result.deviceName = ResourceUtils.getHumanReadableShortName((Resource)device);
                result.deviceType = device.getResourceType();
                result.deviceLocation = device.location();
                result.deviceResourceLocation = device.getLocation();
                return result;
            }
        });
    }

    public static class DeviceInfo {
        String deviceName;
        String deviceResourceLocation;
        Class<? extends PhysicalElement> deviceType;
        Location deviceLocation;

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public String getDeviceResourceLocation() {
            return this.deviceResourceLocation;
        }

        public void setDeviceResourceLocation(String deviceResourceLocation) {
            this.deviceResourceLocation = deviceResourceLocation;
        }

        public Class<? extends PhysicalElement> getDeviceType() {
            return this.deviceType;
        }

        public void setDeviceType(Class<? extends PhysicalElement> deviceType) {
            this.deviceType = deviceType;
        }

        public Location getDeviceLocation() {
            return this.deviceLocation;
        }

        public void setDeviceLocation(Location deviceLocation) {
            this.deviceLocation = deviceLocation;
        }
    }
}

