/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.util.directobjectgui;

import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.html.StaticTable;
import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.form.button.RedirectButton;
import de.iwes.widgets.html.form.button.TemplateInitSingleEmpty;
import de.iwes.widgets.html.form.dropdown.TemplateDropdown;
import de.iwes.widgets.template.DisplayTemplate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.Resource;
import org.ogema.tools.resource.util.ResourceUtils;
import org.smartrplace.util.directresourcegui.LabelProvider;

public abstract class ObjectGUIEditPage<T, R extends Resource> {
    public final long UPDATE_RATE = 5000L;
    protected final ApplicationManager appMan;
    protected final WidgetPage<?> page;
    protected final TemplateInitSingleEmpty<T> init;
    protected final TemplateDropdown<T> drop;
    protected final T aggregatedData;
    protected Map<String, T> knownItems = new HashMap<String, T>();

    public abstract R getResource(OgemaHttpRequest var1);

    public abstract Collection<T> getObjectsInTable(OgemaHttpRequest var1);

    protected String getOverviewPageUrl() {
        return "index.html";
    }

    public ObjectGUIEditPage(WidgetPage<?> page, ApplicationManager appMan, T aggregatedData, Class<T> resourceType, final LabelProvider<T> dropLabels) {
        this.appMan = appMan;
        this.page = page;
        this.aggregatedData = aggregatedData;
        this.init = new TemplateInitSingleEmpty<T>(page, "init", true){
            private static final long serialVersionUID = 1L;

            public T getSelectedItem(OgemaHttpRequest req) {
                Object res = super.getSelectedItem(req);
                if (res != null) {
                    return res;
                }
                res = ObjectGUIEditPage.this.aggregatedData;
                if (res != null) {
                    return res;
                }
                return ObjectGUIEditPage.this.drop.getSelectedItem(req);
            }

            public void updateDependentWidgets(OgemaHttpRequest req) {
                Object res = this.getSelectedItem(req);
                Collection items = ObjectGUIEditPage.this.getObjectsInTable(req);
                ObjectGUIEditPage.this.drop.update(items, req);
                ObjectGUIEditPage.this.drop.selectItem(res, req);
            }

            protected T getItemById(String configId) {
                return ObjectGUIEditPage.this.knownItems.get(configId);
            }
        };
        this.drop = new TemplateDropdown<T>(page, "drop"){
            private static final long serialVersionUID = 1L;

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                ObjectGUIEditPage.this.init.selectItem(this.getSelectedItem(req), req);
            }
        };
        this.drop.setTemplate(new DisplayTemplate<T>(){

            public String getLabel(T object, OgemaLocale locale) {
                return dropLabels.getLabel(object);
            }

            public String getId(T object) {
                String result = ResourceUtils.getValidResourceName((String)object.toString());
                ObjectGUIEditPage.this.knownItems.put(result, object);
                return result;
            }
        });
        this.init.registerDependentWidget(this.drop);
        page.append(this.drop);
    }

    protected void finalize(StaticTable table) {
        String mainUrl;
        if (table != null) {
            ObjectGUIEditPage.registerDependentWidgets(this.drop, table);
        }
        if ((mainUrl = this.getOverviewPageUrl()) != null) {
            RedirectButton mainPageBut = new RedirectButton(this.page, "mainPageBut", "Main page", mainUrl);
            this.page.append((OgemaWidget)mainPageBut);
        }
    }

    public static void registerDependentWidgets(OgemaWidget governor, StaticTable table) {
        for (OgemaWidget el : table.getSubWidgets()) {
            governor.registerDependentWidget(el);
        }
    }
}

