/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.util.directobjectgui;

import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.complextable.DynamicTable;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.object.widget.popup.ClosingPopup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.Resource;
import org.ogema.core.resourcemanager.pattern.ResourcePattern;
import org.ogema.tools.resource.util.ResourceUtils;
import org.smartrplace.util.directobjectgui.ApplicationManagerMinimal;
import org.smartrplace.util.directobjectgui.ObjectGUITableProvider;
import org.smartrplace.util.directobjectgui.ObjectGUITableTemplate;
import org.smartrplace.util.directobjectgui.ObjectResourceGUIHelper;
import org.smartrplace.util.directresourcegui.KnownWidgetHolder;
import org.smartrplace.util.format.WidgetHelper;

public abstract class ObjectGUITablePage<T, R extends Resource>
implements ObjectGUITableProvider<T, R> {
    protected final WidgetPage<?> page;
    protected ObjectGUITableTemplate<T, R> mainTableRowTemplate;
    protected DynamicTable<T> mainTable;
    protected final boolean registerDependentWidgets;
    protected final ClosingPopup<T> popMore1;
    protected final KnownWidgetHolder<T> knownWidgets;
    protected final Alert alert;
    protected final ApplicationManager appMan;
    protected final ApplicationManagerMinimal appManMin;
    protected final T initSampleObject;
    protected final T headerObject;
    protected long retardationOnGET = 0L;

    @Override
    public abstract R getResource(T var1, OgemaHttpRequest var2);

    public abstract void addWidgetsAboveTable();

    protected void addWidgetsBelowTable() {
    }

    protected T getHeaderObject() {
        return null;
    }

    protected String getHeaderText(String columnId, ObjectResourceGUIHelper<T, R> vh, OgemaHttpRequest req) {
        return "Header n/a";
    }

    protected OgemaWidget getHeaderWidget(String columnId, ObjectResourceGUIHelper<T, R> vh, OgemaHttpRequest req) {
        return null;
    }

    public abstract Collection<T> getObjectsInTable(OgemaHttpRequest var1);

    public String getLineId(T object) {
        if (object instanceof Resource) {
            Resource r = (Resource)object;
            return ResourceUtils.getValidResourceName((String)r.getLocation());
        }
        if (object instanceof ResourcePattern) {
            return ResourceUtils.getValidResourceName((String)((ResourcePattern)object).model.getLocation());
        }
        return ResourceUtils.getValidResourceName((String)object.toString().replace('$', '_'));
    }

    private String pid() {
        return WidgetHelper.getValidWidgetId(this.getClass().getName());
    }

    public ObjectGUITablePage(WidgetPage<?> page, ApplicationManager appMan, T initSampleObject) {
        this(page, appMan, initSampleObject, true);
    }

    public ObjectGUITablePage(WidgetPage<?> page, ApplicationManager appMan, T initSampleObject, boolean autoBuildPage) {
        this(page, appMan, initSampleObject, autoBuildPage, true);
    }

    public ObjectGUITablePage(WidgetPage<?> page, ApplicationManager appMan, T initSampleObject, boolean autoBuildPage, boolean registerDependentWidgets) {
        this(page, appMan, null, initSampleObject, autoBuildPage, true);
    }

    public ObjectGUITablePage(WidgetPage<?> page, ApplicationManager appMan, ApplicationManagerMinimal appManMin, T initSampleObject, boolean autoBuildPage, boolean registerDependentWidgets) {
        this.page = page;
        this.appMan = appMan;
        this.appManMin = appManMin;
        this.initSampleObject = initSampleObject;
        this.registerDependentWidgets = registerDependentWidgets;
        this.headerObject = this.getHeaderObject();
        this.alert = new Alert(page, "alert" + this.pid(), "");
        this.knownWidgets = new KnownWidgetHolder(page, "knownWidgets" + this.pid());
        page.append(this.knownWidgets);
        this.popMore1 = new ClosingPopup<T>(page, "popMore1" + this.pid(), "More Information", true, ClosingPopup.ClosingMode.CLOSE){
            private static final long serialVersionUID = 1L;

            public void onGET(OgemaHttpRequest req) {
                Object item = this.getItem(req);
                if (item == null) {
                    return;
                }
            }
        };
        if (autoBuildPage) {
            this.triggerPageBuild();
        }
    }

    public void triggerPageBuild() {
        this.page.append(this.popMore1);
        this.mainTableRowTemplate = new ObjectGUITableTemplate<T, R>(new ObjectGUITableTemplate.ObjectTableProvider<T>(){

            @Override
            public DynamicTable<T> getTable(OgemaHttpRequest req) {
                return ObjectGUITablePage.this.mainTable;
            }
        }, this.initSampleObject, this.appMan, this.appManMin, this.headerObject != null, this.registerDependentWidgets){

            @Override
            protected RowTemplate.Row addRow(T object, ObjectResourceGUIHelper<T, R> vh, String id, OgemaHttpRequest req) {
                RowTemplate.Row row = new RowTemplate.Row();
                if (ObjectGUITablePage.this.headerObject != null && req != null && object.toString().equals(ObjectGUITablePage.this.headerObject.toString())) {
                    LinkedHashMap<String, Object> map2 = this.mhInit.getHeader();
                    for (String columnId : map2.keySet()) {
                        String headerText = ObjectGUITablePage.this.getHeaderText(columnId, vh, req);
                        if (headerText != null) {
                            row.addCell(columnId, (Object)headerText);
                            continue;
                        }
                        OgemaWidget w = ObjectGUITablePage.this.getHeaderWidget(columnId, vh, req);
                        row.addCell(columnId, (Object)w);
                    }
                    return row;
                }
                ObjectGUITablePage.this.addWidgets(object, vh, id, req, row, ObjectGUITablePage.this.appMan);
                return row;
            }

            @Override
            protected R getResource(T object, OgemaHttpRequest req) {
                return ObjectGUITablePage.this.getResource(object, req);
            }

            public String getLineId(T object) {
                if (ObjectGUITablePage.this.headerObject != null && object.toString().equals(ObjectGUITablePage.this.headerObject.toString())) {
                    return "__headerRow__";
                }
                String li = ObjectGUITablePage.this.getLineId(object);
                if (li != null) {
                    return li;
                }
                return super.getLineId(object);
            }
        };
        this.mainTable = new DynamicTable<T>(this.page, "appTable" + this.pid()){
            private static final long serialVersionUID = 1L;

            public void onGET(OgemaHttpRequest req) {
                Collection<Object> data;
                if (ObjectGUITablePage.this.headerObject != null) {
                    data = new ArrayList();
                    data.add(ObjectGUITablePage.this.headerObject);
                    data.addAll(ObjectGUITablePage.this.getObjectsInTable(req));
                } else {
                    data = ObjectGUITablePage.this.getObjectsInTable(req);
                }
                this.updateRows(data, req);
                if (ObjectGUITablePage.this.retardationOnGET > 0L) {
                    try {
                        Thread.sleep(ObjectGUITablePage.this.retardationOnGET);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.mainTable.setRowTemplate(this.mainTableRowTemplate);
        this.addWidgetsAboveTable();
        this.page.append((OgemaWidget)this.alert);
        this.page.append(this.mainTable);
        this.addWidgetsBelowTable();
    }

    public WidgetPage<?> getPage() {
        return this.page;
    }

    public void triggerOnPost(OgemaWidget governor, OgemaWidget target) {
        if (this.registerDependentWidgets) {
            governor.registerDependentWidget(target);
        } else {
            governor.triggerAction(target, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        }
    }
}

