/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.util.directobjectgui;

import de.iwes.util.format.StringFormatHelper;
import de.iwes.util.resource.ResourceHelper;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.html.form.button.TemplateInitSingleEmpty;
import de.iwes.widgets.html.form.button.TemplateRedirectButton;
import de.iwes.widgets.html.form.label.Label;
import de.iwes.widgets.html.form.textfield.TextField;
import de.iwes.widgets.resource.widget.calendar.DatepickerTimeResource;
import de.iwes.widgets.resource.widget.dropdown.ResourceDropdown;
import de.iwes.widgets.resource.widget.dropdown.ValueResourceDropdown;
import de.iwes.widgets.resource.widget.init.ResourceRedirectButton;
import de.iwes.widgets.resource.widget.textfield.BooleanResourceCheckbox;
import java.awt.IllegalComponentStateException;
import java.math.BigInteger;
import java.util.Map;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.Resource;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.model.simple.SingleValueResource;
import org.ogema.core.model.simple.StringResource;
import org.ogema.core.model.simple.TimeResource;
import org.ogema.core.model.units.TemperatureResource;
import org.ogema.tools.resource.util.ResourceUtils;
import org.ogema.tools.resource.util.TimeUtils;
import org.ogema.tools.resource.util.ValueResourceUtils;
import org.smartrplace.tissue.util.format.StringFormatHelperSP;
import org.smartrplace.util.directobjectgui.ObjectGUIHelperBase;
import org.smartrplace.util.directresourcegui.LabelLongValue;
import org.smartrplace.util.directresourcegui.SingleValueResourceAccess;
import org.smartrplace.util.file.ApacheFileAdditions;
import org.smartrplace.util.format.ValueConverter;
import org.smartrplace.util.format.ValueFormat;

public abstract class ObjectResourceGUIHelper<T, R extends Resource>
extends ObjectGUIHelperBase<T> {
    protected boolean doRegisterDependentWidgets = false;
    protected final TemplateInitSingleEmpty<T> initObject;
    protected final ApplicationManager appMan;

    protected abstract R getResource(T var1, OgemaHttpRequest var2);

    public ObjectResourceGUIHelper(WidgetPage<?> page, TemplateInitSingleEmpty<T> init, ApplicationManager appMan, boolean acceptMissingResources) {
        super(page, acceptMissingResources);
        this.initObject = init;
        this.appMan = appMan;
    }

    public ObjectResourceGUIHelper(WidgetPage<?> page, T fixedGatewayInfo, ApplicationManager appMan, boolean acceptMissingResources) {
        super(page, fixedGatewayInfo, acceptMissingResources);
        this.initObject = null;
        this.appMan = appMan;
    }

    public ObjectResourceGUIHelper(OgemaWidget parent, OgemaHttpRequest req, T fixedGatewayInfo, ApplicationManager appMan, boolean acceptMissingResources) {
        super(parent, req, fixedGatewayInfo, acceptMissingResources);
        this.initObject = null;
        this.appMan = appMan;
    }

    public Label stringLabel(String widgetId, String lineId, StringResource source, RowTemplate.Row row) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        Label result = this.stringLabel(widgetId + lineId, source, null, null);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public Label stringLabel(String widgetId, String lineId, String text, RowTemplate.Row row) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        Label result = this.stringLabel(widgetId + lineId, null, null, text);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public Label stringLabel(StringResource source) {
        return this.stringLabel("stringLabel" + ++counter, source, null, null);
    }

    public Label stringLabel(String subResourceName) {
        return this.stringLabel("stringLabel" + ++counter, (StringResource)null, subResourceName, null);
    }

    private Label stringLabel(String widgetId, StringResource optSource, String altId, final String text) {
        final SingleValueResourceAccess<StringResource> sva = text != null ? null : new SingleValueResourceAccess<StringResource>(optSource, altId);
        ObjectGUIHelperBase.LabelFlex result = new ObjectGUIHelperBase.LabelFlex(widgetId, this){

            @Override
            public void onGET(OgemaHttpRequest req) {
                if (text != null) {
                    this.myLabel.setText(text, req);
                } else {
                    StringResource source = (StringResource)ObjectResourceGUIHelper.this.getResource(sva, req, null);
                    if (source == null || !source.isActive()) {
                        this.myLabel.setText("n.a.", req);
                        return;
                    }
                    this.myLabel.setText(source.getValue(), req);
                }
            }
        };
        return result.myLabel;
    }

    public Label floatLabel(String widgetId, String lineId, FloatResource source, RowTemplate.Row row, String format) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        Label result = this.floatLabel(widgetId + lineId, source, null, format);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public Label floatLabel(FloatResource source, String format) {
        return this.floatLabel("floatLabel" + ++counter, source, null, format);
    }

    public Label floatLabel(String subResourceName, String format) {
        return this.floatLabel("floatLabel" + ++counter, null, subResourceName, format);
    }

    private Label floatLabel(String widgetId, FloatResource optSource, String altId, final String format) {
        final SingleValueResourceAccess<FloatResource> sva = new SingleValueResourceAccess<FloatResource>(optSource, altId);
        ObjectGUIHelperBase.LabelFlex result = new ObjectGUIHelperBase.LabelFlex(widgetId, this){

            @Override
            public void onGET(OgemaHttpRequest req) {
                FloatResource source = (FloatResource)ObjectResourceGUIHelper.this.getResource(sva, req, null);
                if (source == null || !source.isActive()) {
                    this.myLabel.setText("n.a.", req);
                    return;
                }
                String val = format != null ? String.format(format, Float.valueOf(source.getValue())) : String.format("%.1f", Float.valueOf(source.getValue()));
                this.myLabel.setText(val, req);
            }
        };
        return result.myLabel;
    }

    public Label intLabel(String widgetId, String lineId, IntegerResource source, RowTemplate.Row row, int mode) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        Label result = this.intLabel(widgetId + lineId, source, null, mode);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public Label intLabel(IntegerResource source, int mode) {
        return this.intLabel("intLabel" + ++counter, source, null, mode);
    }

    public Label intLabel(String subResourceName, int mode) {
        return this.intLabel("intLabel" + ++counter, null, subResourceName, mode);
    }

    private Label intLabel(String widgetId, IntegerResource optSource, String altId, final int mode) {
        final SingleValueResourceAccess<IntegerResource> sva = new SingleValueResourceAccess<IntegerResource>(optSource, altId);
        ObjectGUIHelperBase.LabelFlex result = new ObjectGUIHelperBase.LabelFlex(widgetId, this){

            @Override
            public void onGET(OgemaHttpRequest req) {
                IntegerResource source = (IntegerResource)ObjectResourceGUIHelper.this.getResource(sva, req, null);
                if (source == null || !source.isActive()) {
                    this.myLabel.setText("n.a.", req);
                    return;
                }
                switch (mode) {
                    default: 
                }
                String val = "" + source.getValue();
                this.myLabel.setText(val, req);
            }
        };
        return result.myLabel;
    }

    public Label timeLabel(String widgetId, String lineId, TimeResource source, RowTemplate.Row row, int mode) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        Label result = this.timeLabel(widgetId + lineId, source, null, mode);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public Label timeLabel(TimeResource source, int mode) {
        return this.timeLabel("timeLabel" + ++counter, source, null, mode);
    }

    public Label timeLabel(String subResourceName, int mode) {
        return this.timeLabel("timeLabel" + ++counter, null, subResourceName, mode);
    }

    private Label timeLabel(String widgetId, TimeResource optSource, String altId, final int mode) {
        final SingleValueResourceAccess<TimeResource> sva = new SingleValueResourceAccess<TimeResource>(optSource, altId);
        ObjectGUIHelperBase.LabelFlex result = new ObjectGUIHelperBase.LabelFlex(widgetId, this){

            @Override
            public void onGET(OgemaHttpRequest req) {
                String time;
                TimeResource source = (TimeResource)ObjectResourceGUIHelper.this.getResource(sva, req, null);
                if (source == null || !source.isActive()) {
                    this.myLabel.setText("n.a.", req);
                    return;
                }
                switch (mode) {
                    case 1: {
                        time = StringFormatHelper.getFormattedTimeOfDay((long)source.getValue());
                        break;
                    }
                    case 2: {
                        if (source.getValue() <= 0L) {
                            time = "not set";
                            break;
                        }
                        time = StringFormatHelper.getFormattedAgoValue((ApplicationManager)ObjectResourceGUIHelper.this.appMan, (TimeResource)source);
                        break;
                    }
                    case 3: {
                        if (source.getValue() <= 0L) {
                            time = "not set";
                            break;
                        }
                        time = StringFormatHelper.getFormattedFutureValue((ApplicationManager)ObjectResourceGUIHelper.this.appMan, (TimeResource)source);
                        break;
                    }
                    case 4: {
                        if (source.getValue() <= 0L) {
                            time = "not set";
                            break;
                        }
                        time = TimeUtils.getDateString((long)source.getValue());
                        break;
                    }
                    default: {
                        time = source.getValue() <= 0L ? "not set" : TimeUtils.getDateAndTimeString((long)source.getValue());
                    }
                }
                this.myLabel.setText(time, req);
            }
        };
        return result.myLabel;
    }

    public Label fileSizeLabel(String widgetId, String lineId, TimeResource source, RowTemplate.Row row, LongProvider provider) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        Label result = this.fileSizeLabel(widgetId + lineId, source, null, provider);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public Label fileSizeLabel(TimeResource source, LongProvider provider) {
        return this.fileSizeLabel("fileSizeLabel" + ++counter, source, null, provider);
    }

    public Label fileSizeLabel(String subResourceName, LongProvider provider) {
        return this.fileSizeLabel("fileSizeLabel" + ++counter, null, subResourceName, provider);
    }

    private Label fileSizeLabel(String widgetId, TimeResource optSource, String altId, final LongProvider provider) {
        final SingleValueResourceAccess<TimeResource> sva = new SingleValueResourceAccess<TimeResource>(optSource, altId);
        ObjectGUIHelperBase.LabelFlex result = new ObjectGUIHelperBase.LabelFlex(widgetId, this){

            @Override
            public void onGET(OgemaHttpRequest req) {
                long value;
                if (provider != null) {
                    LabelLongValue llv = provider.getValue(req);
                    if (llv.alternativeText != null) {
                        this.myLabel.setText(llv.alternativeText, req);
                        return;
                    }
                    value = llv.value;
                } else {
                    TimeResource source = (TimeResource)ObjectResourceGUIHelper.this.getResource(sva, req, null);
                    if (source == null || !source.isActive()) {
                        this.myLabel.setText("n.a.", req);
                        return;
                    }
                    value = source.getValue();
                }
                this.myLabel.setText(ApacheFileAdditions.byteCountToDisplaySize(BigInteger.valueOf(value)), req);
            }
        };
        return result.myLabel;
    }

    public Label resourceLabel(String widgetId, String lineId, Resource source, RowTemplate.Row row, int mode) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        Label result = this.resourceLabel(widgetId + lineId, source, null, mode);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public Label resourceLabel(Resource source, int mode) {
        return this.resourceLabel("resourceLabel" + ++counter, source, null, mode);
    }

    public Label resourceLabel(String subResourceName, int mode) {
        return this.resourceLabel("resourceLabel" + ++counter, null, subResourceName, mode);
    }

    private Label resourceLabel(String widgetId, Resource optSource, String altId, final int mode) {
        final SingleValueResourceAccess<Resource> sva = new SingleValueResourceAccess<Resource>(optSource, altId);
        ObjectGUIHelperBase.LabelFlex result = new ObjectGUIHelperBase.LabelFlex(widgetId, this){

            @Override
            public void onGET(OgemaHttpRequest req) {
                Object source = ObjectResourceGUIHelper.this.getResource(sva, req, null);
                if (source == null || !source.isActive()) {
                    this.myLabel.setText("n.a.", req);
                    return;
                }
                switch (mode) {
                    case 1: {
                        this.myLabel.setText(ResourceUtils.getHumanReadableShortName(source), req);
                        break;
                    }
                    case 2: {
                        this.myLabel.setText(source.getLocation(), req);
                        break;
                    }
                    case 3: {
                        this.myLabel.setText(source.getPath(), req);
                        break;
                    }
                    case 4: {
                        this.myLabel.setText(source.getName(), req);
                        break;
                    }
                    case 10: {
                        this.myLabel.setText(source.getResourceType().getName(), req);
                        break;
                    }
                    case 11: {
                        this.myLabel.setText(source.getResourceType().getSimpleName(), req);
                        break;
                    }
                    case 20: {
                        if (source instanceof SingleValueResource) {
                            this.myLabel.setText(ValueResourceUtils.getValue((SingleValueResource)((SingleValueResource)source)), req);
                            break;
                        }
                        this.myLabel.setText("--", req);
                        break;
                    }
                    default: {
                        this.myLabel.setText(ResourceUtils.getHumanReadableName(source), req);
                    }
                }
            }
        };
        return result.myLabel;
    }

    public TextField integerEdit(String widgetId, String lineId, IntegerResource source, RowTemplate.Row row, Alert alert, int minimumAllowed, int maximumAllowed, String notAllowedMessage) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        TextField result = this.integerEdit(widgetId + lineId, source, null, alert, minimumAllowed, maximumAllowed, notAllowedMessage);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public TextField integerEdit(IntegerResource source, Alert alert, int minimumAllowed, int maximumAllowed, String notAllowedMessage) {
        return this.integerEdit("integerEdit" + ++counter, source, null, alert, minimumAllowed, maximumAllowed, notAllowedMessage);
    }

    public TextField integerEdit(String subResourceName, Alert alert, int minimumAllowed, int maximumAllowed, String notAllowedMessage) {
        return this.integerEdit("integerEdit" + ++counter, null, subResourceName, alert, minimumAllowed, maximumAllowed, notAllowedMessage);
    }

    private TextField integerEdit(String widgetId, IntegerResource optSource, String altId, final Alert alert, final int minimumAllowed, final int maximumAllowed, String notAllowedMessage) {
        final SingleValueResourceAccess<IntegerResource> sva = new SingleValueResourceAccess<IntegerResource>(optSource, altId);
        final String notAllowedMessageUsed = notAllowedMessage == null ? "Value not Allowed!" : notAllowedMessage;
        ObjectGUIHelperBase.TextFieldFlex updateInterval = new ObjectGUIHelperBase.TextFieldFlex(widgetId, this){

            @Override
            public void onGET(OgemaHttpRequest req) {
                IntegerResource source = ObjectResourceGUIHelper.this.getResource(sva, req, IntegerResource.class);
                this.myField.setValue(source.getValue() + "", req);
            }

            @Override
            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                int value;
                IntegerResource source = ObjectResourceGUIHelper.this.getResource(sva, req, IntegerResource.class);
                String val = this.myField.getValue(req);
                try {
                    value = Integer.parseInt(val);
                }
                catch (NullPointerException | NumberFormatException e) {
                    if (alert != null) {
                        alert.showAlert(notAllowedMessageUsed, false, req);
                    }
                    return;
                }
                if (value < minimumAllowed) {
                    if (alert != null) {
                        alert.showAlert(notAllowedMessageUsed, false, req);
                    }
                    return;
                }
                if (value > maximumAllowed) {
                    if (alert != null) {
                        alert.showAlert(notAllowedMessageUsed, false, req);
                    }
                    return;
                }
                if (!source.exists()) {
                    source.create();
                    source.setValue(value);
                    source.activate(true);
                } else {
                    source.setValue(value);
                }
                if (alert != null) {
                    alert.showAlert("New value: " + value, true, req);
                }
            }
        };
        if (alert != null) {
            this.triggerOnPost((OgemaWidget)updateInterval.myField, (OgemaWidget)alert);
        }
        return updateInterval.myField;
    }

    public TextField integerEditExt(String widgetId, String lineId, IntegerResource source, RowTemplate.Row row, ValueConverter checker) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        TextField result = this.integerEditExt(widgetId + lineId, source, null, checker);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public TextField integerEditExt(String subResourceName, ValueConverter checker) {
        return this.integerEditExt("integerEdit" + ++counter, null, subResourceName, checker);
    }

    public TextField integerEditExt(String widgetId, IntegerResource optSource, String altId, final ValueConverter checker) {
        final SingleValueResourceAccess<IntegerResource> sva = new SingleValueResourceAccess<IntegerResource>(optSource, altId);
        ObjectGUIHelperBase.TextFieldFlex updateInterval = new ObjectGUIHelperBase.TextFieldFlex(widgetId, this){

            @Override
            public void onGET(OgemaHttpRequest req) {
                IntegerResource source = ObjectResourceGUIHelper.this.getResource(sva, req, IntegerResource.class);
                this.myField.setValue(source.getValue() + "", req);
            }

            @Override
            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                IntegerResource source = ObjectResourceGUIHelper.this.getResource(sva, req, IntegerResource.class);
                String val = this.myField.getValue(req);
                Integer value = checker.checkNewValueInt(val, req);
                if (value == null) {
                    return;
                }
                if (!source.exists()) {
                    source.create();
                    source.setValue(value.intValue());
                    source.activate(true);
                } else {
                    source.setValue(value.intValue());
                }
            }
        };
        if (checker.getAlert() != null) {
            this.triggerOnPost((OgemaWidget)updateInterval.myField, (OgemaWidget)checker.getAlert());
        }
        return updateInterval.myField;
    }

    public TextField timeEdit(String widgetId, String lineId, TimeResource source, RowTemplate.Row row, Alert alert, long minimumAllowed, long maximumAllowed, String notAllowedMessage, int mode) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        TextField result = this.timeEdit(widgetId + lineId, source, null, alert, minimumAllowed, maximumAllowed, notAllowedMessage, mode);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public TextField timeEdit(TimeResource source, Alert alert, long minimumAllowed, long maximumAllowed, String notAllowedMessage, int mode) {
        return this.timeEdit("timeEdit" + ++counter, source, null, alert, minimumAllowed, maximumAllowed, notAllowedMessage, mode);
    }

    public TextField timeEdit(String subResourceName, Alert alert, long minimumAllowed, long maximumAllowed, String notAllowedMessage, int mode) {
        return this.timeEdit("timeEdit" + ++counter, null, subResourceName, alert, minimumAllowed, maximumAllowed, notAllowedMessage, mode);
    }

    private TextField timeEdit(String widgetId, TimeResource optSource, String altId, final Alert alert, final long minimumAllowed, final long maximumAllowed, String notAllowedMessage, final int mode) {
        final SingleValueResourceAccess<TimeResource> sva = new SingleValueResourceAccess<TimeResource>(optSource, altId);
        class LastMode {
            public int lastMode;

            LastMode() {
            }
        }
        final LastMode lastMode = new LastMode();
        final String notAllowedMessageUsed = notAllowedMessage == null ? "Value not Allowed!" : notAllowedMessage;
        ObjectGUIHelperBase.TextFieldFlex updateInterval = new ObjectGUIHelperBase.TextFieldFlex(widgetId, this){
            {
                super(widgetId, vrh);
            }

            @Override
            public void onGET(OgemaHttpRequest req) {
                TimeResource source = ObjectResourceGUIHelper.this.getResource(sva, req, TimeResource.class);
                switch (mode) {
                    case 1: {
                        this.myField.setValue(source.getValue() / 1000L + "", req);
                        break;
                    }
                    case 2: {
                        this.myField.setValue(source.getValue() / 60000L + "", req);
                        break;
                    }
                    case 3: {
                        this.myField.setValue(source.getValue() / 3600000L + "", req);
                        break;
                    }
                    case 4: {
                        this.myField.setValue(source.getValue() / 86400000L + "", req);
                        break;
                    }
                    case 5: {
                        this.myField.setValue(source.getValue() / -1702967296L + "", req);
                        break;
                    }
                    case -1: {
                        String s = StringFormatHelperSP.getFormattedValue(source.getValue(), 360);
                        lastMode.lastMode = this.getLastMode(s);
                        this.myField.setValue(s, req);
                        break;
                    }
                    default: {
                        this.myField.setValue(source.getValue() + "", req);
                    }
                }
            }

            @Override
            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                int value;
                TimeResource source = ObjectResourceGUIHelper.this.getResource(sva, req, TimeResource.class);
                String val = this.myField.getValue(req);
                int flexMode = -99;
                if (mode == -1) {
                    flexMode = this.getLastMode(val);
                    if (flexMode <= 0) {
                        flexMode = lastMode.lastMode;
                    }
                    val = val.replaceAll("[^\\d.]", "");
                }
                try {
                    value = Integer.parseInt(val);
                }
                catch (NullPointerException | NumberFormatException e) {
                    if (alert != null) {
                        alert.showAlert(notAllowedMessageUsed, false, req);
                    }
                    return;
                }
                if ((long)value < minimumAllowed) {
                    if (alert != null) {
                        alert.showAlert(notAllowedMessageUsed, false, req);
                    }
                    return;
                }
                if ((long)value > maximumAllowed) {
                    alert.showAlert(notAllowedMessageUsed, false, req);
                    return;
                }
                value = mode == -1 ? this.getCorerrectedValue(value, flexMode) : this.getCorerrectedValue(value, mode);
                if (!source.exists()) {
                    source.create();
                    source.setValue((long)value);
                    source.activate(true);
                } else {
                    source.setValue((long)value);
                }
                if (alert != null) {
                    alert.showAlert("New interval " + value + " ms", true, req);
                }
            }

            private int getLastMode(String s) {
                if (s.endsWith("sec")) {
                    return 1;
                }
                if (s.endsWith("min")) {
                    return 2;
                }
                if (s.endsWith("h")) {
                    return 3;
                }
                if (s.endsWith("d")) {
                    return 4;
                }
                if (s.endsWith("month")) {
                    return 5;
                }
                return 0;
            }

            private int getCorerrectedValue(int value, int mode2) {
                switch (mode2) {
                    case 1: {
                        return value * 1000;
                    }
                    case 2: {
                        return value * 60000;
                    }
                    case 3: {
                        return value * 3600000;
                    }
                    case 4: {
                        return value * 86400000;
                    }
                    case 5: {
                        return value * -1702967296;
                    }
                }
                return value;
            }
        };
        if (alert != null) {
            this.triggerOnPost((OgemaWidget)updateInterval.myField, (OgemaWidget)alert);
        }
        return updateInterval.myField;
    }

    public TextField floatEdit(String widgetId, String lineId, FloatResource source, RowTemplate.Row row, Alert alert, float minimumAllowed, float maximumAllowed, String notAllowedMessage) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        TextField result = this.floatEdit(widgetId + lineId, source, null, alert, minimumAllowed, maximumAllowed, notAllowedMessage, 0);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public TextField floatEdit(FloatResource source, Alert alert, float minimumAllowed, float maximumAllowed, String notAllowedMessage) {
        return this.floatEdit("floatEdit" + ++counter, source, null, alert, minimumAllowed, maximumAllowed, notAllowedMessage, 0);
    }

    public TextField floatEdit(String subResourceName, Alert alert, float minimumAllowed, float maximumAllowed, String notAllowedMessage) {
        return this.floatEdit("floatEdit" + ++counter, null, subResourceName, alert, minimumAllowed, maximumAllowed, notAllowedMessage, 0);
    }

    private TextField floatEdit(String widgetId, FloatResource optSource, String altId, final Alert alert, final float minimumAllowed, final float maximumAllowed, String notAllowedMessage, final int mode) {
        final SingleValueResourceAccess<FloatResource> sva = new SingleValueResourceAccess<FloatResource>(optSource, altId);
        final String notAllowedMessageUsed = notAllowedMessage == null ? "Value not Allowed!" : notAllowedMessage;
        ObjectGUIHelperBase.TextFieldFlex updateInterval = new ObjectGUIHelperBase.TextFieldFlex(widgetId, this){

            @Override
            public void onGET(OgemaHttpRequest req) {
                FloatResource source = ObjectResourceGUIHelper.this.getResource(sva, req, FloatResource.class);
                if (source instanceof TemperatureResource && mode == 0) {
                    this.myField.setValue(((TemperatureResource)source).getCelsius() + "", req);
                } else {
                    this.myField.setValue(source.getValue() + "", req);
                }
            }

            private void setValue(FloatResource source, float value) {
                if (source instanceof TemperatureResource && mode == 0) {
                    ((TemperatureResource)source).setCelsius(value);
                } else {
                    source.setValue(value);
                }
            }

            @Override
            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                float value;
                FloatResource source = ObjectResourceGUIHelper.this.getResource(sva, req, FloatResource.class);
                String val = this.myField.getValue(req);
                try {
                    value = Float.parseFloat(val);
                }
                catch (NullPointerException | NumberFormatException e) {
                    if (alert != null) {
                        alert.showAlert(notAllowedMessageUsed, false, req);
                    }
                    return;
                }
                if (value < minimumAllowed) {
                    if (alert != null) {
                        alert.showAlert(notAllowedMessageUsed, false, req);
                    }
                    return;
                }
                if (value > maximumAllowed) {
                    if (alert != null) {
                        alert.showAlert(notAllowedMessageUsed, false, req);
                    }
                    return;
                }
                if (!source.exists()) {
                    source.create();
                    this.setValue(source, value);
                    source.activate(true);
                } else {
                    this.setValue(source, value);
                }
                if (alert != null) {
                    alert.showAlert("New value: " + value, true, req);
                }
            }
        };
        if (alert != null) {
            this.triggerOnPost((OgemaWidget)updateInterval.myField, (OgemaWidget)alert);
        }
        return updateInterval.myField;
    }

    public TextField stringEdit(String widgetId, String lineId, StringResource source, RowTemplate.Row row, Alert alert) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        TextField result = this.stringEdit(widgetId + lineId, source, null, alert);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public TextField stringEdit(StringResource source, Alert alert) {
        return this.stringEdit("stringEdit" + ++counter, source, null, alert);
    }

    public TextField stringEdit(String subResourceName, Alert alert) {
        return this.stringEdit("stringEdit" + ++counter, null, subResourceName, alert);
    }

    private TextField stringEdit(String widgetId, StringResource optSource, String altId, final Alert alert) {
        final SingleValueResourceAccess<StringResource> sva = new SingleValueResourceAccess<StringResource>(optSource, altId);
        ObjectGUIHelperBase.TextFieldFlex updateInterval = new ObjectGUIHelperBase.TextFieldFlex(widgetId, this){

            @Override
            public void onGET(OgemaHttpRequest req) {
                StringResource source = ObjectResourceGUIHelper.this.getResource(sva, req, StringResource.class);
                this.myField.setValue(source.getValue() + "", req);
            }

            @Override
            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                StringResource source = ObjectResourceGUIHelper.this.getResource(sva, req, StringResource.class);
                String val = this.myField.getValue(req);
                if (!source.exists()) {
                    source.create();
                    source.setValue(val);
                    source.activate(true);
                } else {
                    source.setValue(val);
                }
                if (alert != null) {
                    alert.showAlert("New value: " + val, true, req);
                }
            }
        };
        if (alert != null) {
            this.triggerOnPost((OgemaWidget)updateInterval.myField, (OgemaWidget)alert);
        }
        return updateInterval.myField;
    }

    public DatepickerTimeResource datepicker(String widgetId, String lineId, TimeResource source, RowTemplate.Row row) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        DatepickerTimeResource result = this.datepicker(widgetId + lineId, source, null, null, null, null);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public DatepickerTimeResource datepicker(TimeResource source) {
        return this.datepicker("timeEdit" + ++counter, source, null, null, null, null);
    }

    public DatepickerTimeResource datepicker(String subResourceName) {
        return this.datepicker("timeEdit" + ++counter, null, subResourceName, null, null, null);
    }

    public DatepickerTimeResource datepicker(String subResourceName, String format, String defaultDate, String viewMode) {
        return this.datepicker("timeEdit" + ++counter, null, subResourceName, format, defaultDate, viewMode);
    }

    private DatepickerTimeResource datepicker(String widgetId, TimeResource optSource, String altId, String format, String defaultDate, String viewMode) {
        final SingleValueResourceAccess<TimeResource> sva = new SingleValueResourceAccess<TimeResource>(optSource, altId);
        ObjectGUIHelperBase.DatepickerFlex updateInterval = new ObjectGUIHelperBase.DatepickerFlex(widgetId, this, format, defaultDate, viewMode){

            @Override
            public void onGET(OgemaHttpRequest req) {
                TimeResource source = ObjectResourceGUIHelper.this.getResource(sva, req, TimeResource.class);
                this.myDrop.selectItem(source, req);
            }
        };
        return updateInterval.myDrop;
    }

    public TemplateRedirectButton<T> linkingButton(String widgetId, String lineId, T source, RowTemplate.Row row, String buttonText, String url) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        TemplateRedirectButton<T> result = this.linkingButton(widgetId + lineId, source, buttonText, url);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public TemplateRedirectButton<T> linkingButton(T source, String buttonText, String url) {
        return this.linkingButton("linkingButton" + ++counter, source, buttonText, url);
    }

    private TemplateRedirectButton<T> linkingButton(String widgetId, final T optSource, String buttonText, String url) {
        ObjectGUIHelperBase.TemplateRedirectButtonFlex button = new ObjectGUIHelperBase.TemplateRedirectButtonFlex<T>(widgetId, this, buttonText, url){

            @Override
            public void onPrePOST(String s, OgemaHttpRequest req) {
                if (optSource != null) {
                    this.myButton.selectItem(optSource, req);
                }
            }
        };
        return button.myButton;
    }

    public ResourceRedirectButton<R> linkingButton(String subResourceName, String buttonText, String url) {
        return this.linkingButton("linkingButton" + ++counter, null, subResourceName, buttonText, url);
    }

    private ResourceRedirectButton<R> linkingButton(String widgetId, R optSource, String altId, String buttonText, String url) {
        final SingleValueResourceAccess<R> sva = new SingleValueResourceAccess<R>(optSource, altId);
        ObjectGUIHelperBase.ResourceRedirectButtonFlex button = new ObjectGUIHelperBase.ResourceRedirectButtonFlex<R>(widgetId, this, buttonText, url){

            @Override
            public void onPrePOST(String s, OgemaHttpRequest req) {
                Object source = ObjectResourceGUIHelper.this.getResource(sva, req, null);
                this.myButton.selectItem(source, req);
            }
        };
        return button.myButton;
    }

    public BooleanResourceCheckbox booleanEdit(String widgetId, String lineId, BooleanResource source, RowTemplate.Row row) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        BooleanResourceCheckbox result = this.booleanEdit(widgetId + lineId, source, null);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public BooleanResourceCheckbox booleanEdit(BooleanResource source) {
        return this.booleanEdit("booleanEdit" + ++counter, source, null);
    }

    public BooleanResourceCheckbox booleanEdit(String subResourceName) {
        return this.booleanEdit("booleanEdit" + ++counter, null, subResourceName);
    }

    private BooleanResourceCheckbox booleanEdit(String widgetId, BooleanResource optSource, String altId) {
        final SingleValueResourceAccess<BooleanResource> sva = new SingleValueResourceAccess<BooleanResource>(optSource, altId);
        ObjectGUIHelperBase.BooleanResourceCheckboxFlex boolWidget = new ObjectGUIHelperBase.BooleanResourceCheckboxFlex(widgetId, this){

            @Override
            public void onGET(OgemaHttpRequest req) {
                BooleanResource source = ObjectResourceGUIHelper.this.getResource(sva, req, BooleanResource.class);
                this.myCheckbox.selectItem(source, req);
            }

            @Override
            public void onPrePOST(String data, OgemaHttpRequest req) {
                BooleanResource source = ObjectResourceGUIHelper.this.getResource(sva, req, BooleanResource.class);
                if (!source.exists()) {
                    source.create();
                    source.activate(true);
                }
            }
        };
        return boolWidget.myCheckbox;
    }

    public <S extends SingleValueResource> ValueResourceDropdown<S> dropdown(String widgetId, String lineId, S source, RowTemplate.Row row, Map<String, String> valuesToSet) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        ValueResourceDropdown<S> result = this.dropdown(widgetId + lineId, source, null, valuesToSet, null);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public <S extends SingleValueResource> ValueResourceDropdown<S> dropdown(S source, Map<String, String> valuesToSet) {
        return this.dropdown("dropdown" + ++counter, source, null, valuesToSet, null);
    }

    public <S extends SingleValueResource> ValueResourceDropdown<S> dropdown(String subResourceName, Map<String, String> valuesToSet, Class<S> resourceType) {
        return this.dropdown("dropdown" + ++counter, null, subResourceName, valuesToSet, resourceType);
    }

    private <S extends SingleValueResource> ValueResourceDropdown<S> dropdown(String widgetId, S optSource, String altId, Map<String, String> valuesToSet, final Class<S> resourceType) {
        final SingleValueResourceAccess<S> sva = new SingleValueResourceAccess<S>(optSource, altId);
        ObjectGUIHelperBase.ValueResourceDropdownFlex widget = new ObjectGUIHelperBase.ValueResourceDropdownFlex<S>(widgetId, this, valuesToSet){

            @Override
            public void onGET(OgemaHttpRequest req) {
                SingleValueResource source = (SingleValueResource)ObjectResourceGUIHelper.this.getResource(sva, req, resourceType);
                this.myDrop.selectItem(source, req);
            }

            @Override
            public void onPrePOST(String data, OgemaHttpRequest req) {
                SingleValueResource source = (SingleValueResource)ObjectResourceGUIHelper.this.getResource(sva, req, resourceType);
                if (!source.exists()) {
                    source.create();
                    source.activate(true);
                }
            }
        };
        return widget.myDrop;
    }

    public <S extends Resource> ResourceDropdown<S> referenceDropdownFixedChoice(String widgetId, String lineId, S source, RowTemplate.Row row, Map<S, String> valuesToSet) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        ResourceDropdown<S> result = this.referenceDropdownFixedChoice(widgetId + lineId, source, null, valuesToSet, null);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public <S extends Resource> ResourceDropdown<S> referenceDropdownFixedChoice(S source, Map<S, String> valuesToSet) {
        return this.referenceDropdownFixedChoice("dropdown" + ++counter, source, null, valuesToSet, null);
    }

    public <S extends Resource> ResourceDropdown<S> referenceDropdownFixedChoice(String subResourceName, Map<S, String> valuesToSet, Class<S> resourceType) {
        return this.referenceDropdownFixedChoice("dropdown" + ++counter, null, subResourceName, valuesToSet, resourceType);
    }

    private <S extends Resource> ResourceDropdown<S> referenceDropdownFixedChoice(String widgetId, S optSource, String altId, final Map<S, String> valuesToSet, final Class<S> resourceType) {
        final SingleValueResourceAccess<S> sva = new SingleValueResourceAccess<S>(optSource, altId);
        ObjectGUIHelperBase.ResourceDropdownFlex widget = new ObjectGUIHelperBase.ResourceDropdownFlex<S>(widgetId, this){

            @Override
            public String getLabel(S object, OgemaLocale locale) {
                String result = (String)valuesToSet.get(object);
                if (result != null) {
                    return result;
                }
                return super.getLabel(object, locale);
            }

            @Override
            public void onGET(OgemaHttpRequest req) {
                Object source = ObjectResourceGUIHelper.this.getResource(sva, req, resourceType);
                if (source.exists()) {
                    this.myDrop.selectItem((Object)source.getLocationResource(), req);
                } else {
                    this.myDrop.selectSingleOption("___EMPTY_OPT___", req);
                }
            }

            @Override
            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                Resource selection;
                Object source = ObjectResourceGUIHelper.this.getResource(sva, req, resourceType);
                if (!source.exists()) {
                    source.create();
                    source.activate(true);
                }
                if ((selection = (Resource)this.myDrop.getSelectedItem(req)) == null) {
                    source.delete();
                } else {
                    source.setAsReference(selection);
                }
            }
        };
        widget.myDrop.setDefaultItems(valuesToSet.keySet());
        widget.myDrop.setDefaultAddEmptyOption(true, "(not set)");
        return widget.myDrop;
    }

    protected T getGatewayInfo(OgemaHttpRequest req) {
        if (this.fixedGatewayInfo != null) {
            return (T)this.fixedGatewayInfo;
        }
        return (T)this.initObject.getSelectedItem(req);
    }

    protected <S extends Resource> S getResource(SingleValueResourceAccess<S> sva, OgemaHttpRequest req, Class<? extends S> typeToCreate) {
        R gw = this.getResource(this.getGatewayInfo(req), req);
        if (gw == null) {
            return null;
        }
        if (sva.optSource == null) {
            if (sva.altIdUsed == null) {
                return null;
            }
            Object result = sva.altIdUsed.equals("") ? gw : (typeToCreate == null ? ResourceHelper.getSubResource(gw, (String)sva.altIdUsed) : ResourceHelper.getSubResource(gw, (String)sva.altIdUsed, typeToCreate));
            if (!this.acceptMissingResources && result == null) {
                throw new IllegalStateException("Subresource " + sva.altIdUsed + " not found!");
            }
            if (result.getLocationResource() == null) {
                throw new IllegalComponentStateException("Invalid location should throw framework exception:" + result.getLocation());
            }
            return (S)result;
        }
        return sva.optSource;
    }

    public Label floatLabel(String widgetId, String lineId, float value, RowTemplate.Row row, String format) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        Label result = this.floatLabel(widgetId + lineId, value, format);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public Label floatLabel(float value, String format) {
        return this.floatLabel("floatLabel" + ++counter, value, format);
    }

    private Label floatLabel(String widgetId, final float value, final String format) {
        ObjectGUIHelperBase.LabelFlex result = new ObjectGUIHelperBase.LabelFlex(widgetId, this){

            @Override
            public void onGET(OgemaHttpRequest req) {
                String val = ValueFormat.floatVal(value, format);
                this.myLabel.setText(val, req);
            }
        };
        return result.myLabel;
    }

    public Label intLabel(String widgetId, String lineId, Integer value, RowTemplate.Row row, int mode) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        Label result = this.intLabel(widgetId + lineId, value, mode);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public Label intLabel(Integer value, int mode) {
        return this.intLabel("intLabel" + ++counter, value, mode);
    }

    private Label intLabel(String widgetId, final Integer value, final int mode) {
        ObjectGUIHelperBase.LabelFlex result = new ObjectGUIHelperBase.LabelFlex(widgetId, this){

            @Override
            public void onGET(OgemaHttpRequest req) {
                if (value == null) {
                    this.myLabel.setText("n.a.", req);
                    return;
                }
                switch (mode) {
                    default: 
                }
                String val = "" + value;
                this.myLabel.setText(val, req);
            }
        };
        return result.myLabel;
    }

    public Label timeLabel(String widgetId, String lineId, Long value, RowTemplate.Row row, int mode) {
        if (this.checkLineId(widgetId)) {
            return null;
        }
        widgetId = ResourceUtils.getValidResourceName((String)widgetId);
        Label result = this.timeLabel(widgetId + lineId, value, mode);
        this.finishRowSnippet(row, widgetId, (OgemaWidget)result);
        return result;
    }

    public Label timeLabel(Long value, int mode) {
        return this.timeLabel("timeLabel" + ++counter, value, mode);
    }

    private Label timeLabel(String widgetId, final Long value, final int mode) {
        ObjectGUIHelperBase.LabelFlex result = new ObjectGUIHelperBase.LabelFlex(widgetId, this){

            @Override
            public void onGET(OgemaHttpRequest req) {
                String time;
                if (value == null) {
                    this.myLabel.setText("n.a.", req);
                    return;
                }
                switch (mode) {
                    case 1: {
                        time = StringFormatHelper.getFormattedTimeOfDay((long)value);
                        break;
                    }
                    case 2: {
                        if (value <= 0L) {
                            time = "not set";
                            break;
                        }
                        time = StringFormatHelper.getFormattedAgoValue((ApplicationManager)ObjectResourceGUIHelper.this.appMan, (long)value);
                        break;
                    }
                    case 3: {
                        if (value <= 0L) {
                            time = "not set";
                            break;
                        }
                        time = StringFormatHelper.getFormattedFutureValue((ApplicationManager)ObjectResourceGUIHelper.this.appMan, (long)value);
                        break;
                    }
                    default: {
                        time = value <= 0L ? "not set" : TimeUtils.getDateAndTimeString((long)value);
                    }
                }
                this.myLabel.setText(time, req);
            }
        };
        return result.myLabel;
    }

    public void triggerOnPost(OgemaWidget governor, OgemaWidget target) {
        if (this.doRegisterDependentWidgets) {
            governor.registerDependentWidget(target);
        } else {
            governor.triggerAction(target, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        }
    }

    public void triggerOnPostForRequest(OgemaWidget governor, OgemaWidget target) {
        if (this.doRegisterDependentWidgets) {
            governor.registerDependentWidget(target, this.req);
        } else {
            governor.triggerAction(target, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST, this.req);
        }
    }

    public void setDoRegisterDependentWidgets(boolean doRegisterDependentWidgets) {
        this.doRegisterDependentWidgets = doRegisterDependentWidgets;
    }

    public static interface LongProvider {
        public LabelLongValue getValue(OgemaHttpRequest var1);
    }
}

