/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.util.directresourcegui;

import de.iwes.widgets.api.extended.mode.UpdateMode;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.form.button.Button;
import de.iwes.widgets.resource.widget.multiselect.ResourceMultiselect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ogema.core.model.Resource;
import org.ogema.core.model.ResourceList;

public class ReferencingResourceListSetter<T extends Resource> {
    public final ResourceMultiselect<T> multiSelect;
    public final Button submit;
    private Collection<T> options;
    private Map<T, String> labels = null;
    private List<ResourceList<T>> selectionExclusiveWith = new ArrayList<ResourceList<T>>();
    private boolean changed = false;

    public ReferencingResourceListSetter(OgemaWidget parent, String id, final ResourceList<T> resource, Collection<T> defaultOptions, OgemaHttpRequest req) {
        this.options = defaultOptions == null ? Collections.emptyList() : defaultOptions;
        this.multiSelect = new ResourceMultiselect<T>(parent, id + "Multi", null, UpdateMode.MANUAL, null, req){
            private static final long serialVersionUID = 1L;

            public void onGET(OgemaHttpRequest req) {
                if (resource.exists()) {
                    HashSet items = new HashSet();
                    List items2 = resource.getAllElements();
                    items.addAll(items2);
                    items.addAll(ReferencingResourceListSetter.this.options);
                    this.update(items, req);
                    this.selectItems(items2, req);
                } else {
                    this.update(ReferencingResourceListSetter.this.options, req);
                    this.selectItems(Collections.emptyList(), req);
                }
            }
        };
        this.submit = new Button(parent, id + "submit", "Submit/Add value:", req){
            private static final long serialVersionUID = 1L;

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                List out = ReferencingResourceListSetter.this.multiSelect.getSelectedItems(req);
                if (!resource.exists()) {
                    resource.create();
                    ReferencingResourceListSetter.updateReferencingResourceList(resource, out);
                    resource.activate(false);
                } else {
                    ReferencingResourceListSetter.updateReferencingResourceList(resource, out);
                }
                for (Resource appId : out) {
                    block1: for (ResourceList slist : ReferencingResourceListSetter.this.selectionExclusiveWith) {
                        if (!slist.isActive()) continue;
                        List vals = slist.getAllElements();
                        for (int i = 0; i < slist.size(); ++i) {
                            if (!((Resource)vals.get(i)).equalsLocation(appId)) continue;
                            ((Resource)vals.get(i)).delete();
                            continue block1;
                        }
                    }
                }
                ReferencingResourceListSetter.this.changed = true;
            }
        };
        this.submit.addWidget(this.multiSelect);
        this.submit.registerDependentWidget(this.multiSelect);
    }

    public void setDefaultOptions(Collection<T> options) {
        this.options = options;
    }

    public Collection<T> getDefaultOptions() {
        return this.options;
    }

    public void setLabels(Map<T, String> labels) {
        this.labels = labels;
    }

    public Map<T, String> getLabels() {
        return this.labels;
    }

    public void addExclusiveWithList(ResourceList<T> exList) {
        this.selectionExclusiveWith.add(exList);
    }

    public boolean checkConfirmChanged() {
        if (!this.changed) {
            return false;
        }
        this.changed = false;
        return true;
    }

    public static <S extends Resource> void updateReferencingResourceList(ResourceList<S> resourceList, Collection<S> newResources) {
        for (Resource res : newResources) {
            if (resourceList.contains(res)) continue;
            resourceList.add(res);
        }
        for (Resource exist : resourceList.getAllElements()) {
            boolean found = false;
            for (Resource res : newResources) {
                if (!exist.equalsLocation(res)) continue;
                found = true;
                break;
            }
            if (found) continue;
            exist.delete();
        }
    }
}

