/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.util.directresourcegui;

import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.html.StaticTable;
import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.form.button.RedirectButton;
import de.iwes.widgets.resource.widget.dropdown.ResourceDropdown;
import de.iwes.widgets.resource.widget.init.ResourceInitSingleEmpty;
import de.iwes.widgets.template.DisplayTemplate;
import java.util.Collection;
import java.util.List;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.Resource;
import org.smartrplace.util.directresourcegui.LabelProvider;

public class ResourceEditPage<T extends Resource> {
    public final long UPDATE_RATE = 5000L;
    protected final ApplicationManager appMan;
    protected final WidgetPage<?> page;
    protected final ResourceInitSingleEmpty<T> init;
    protected final ResourceDropdown<T> drop;
    protected final T aggregatedData;

    protected String getOverviewPageUrl() {
        return "index.html";
    }

    public ResourceEditPage(WidgetPage<?> page, final ApplicationManager appMan, T aggregatedData, final Class<T> resourceType, final LabelProvider<T> dropLabels) {
        this.appMan = appMan;
        this.page = page;
        this.aggregatedData = aggregatedData;
        this.init = new ResourceInitSingleEmpty<T>(page, "init", true, appMan){
            private static final long serialVersionUID = 1L;

            public T getSelectedItem(OgemaHttpRequest req) {
                Object res = super.getSelectedItem(req);
                if (res != null) {
                    return res;
                }
                res = ResourceEditPage.this.aggregatedData;
                if (res != null) {
                    return res;
                }
                return (Resource)ResourceEditPage.this.drop.getSelectedItem(req);
            }

            public void updateDependentWidgets(OgemaHttpRequest req) {
                Object res = this.getSelectedItem(req);
                List items = appMan.getResourceAccess().getResources(resourceType);
                ResourceEditPage.this.drop.update((Collection)items, req);
                ResourceEditPage.this.drop.selectItem(res, req);
            }
        };
        this.drop = new ResourceDropdown<T>(page, "drop"){
            private static final long serialVersionUID = 1L;

            public void onPOSTComplete(String data, OgemaHttpRequest req) {
                ResourceEditPage.this.init.selectItem((Resource)this.getSelectedItem(req), req);
            }
        };
        this.drop.setTemplate(new DisplayTemplate<T>(){

            public String getLabel(T object, OgemaLocale locale) {
                return dropLabels.getLabel(object);
            }

            public String getId(T object) {
                return object.getLocation();
            }
        });
        this.init.registerDependentWidget(this.drop);
        page.append(this.drop);
    }

    protected void finalize(StaticTable table) {
        String mainUrl;
        if (table != null) {
            ResourceEditPage.registerDependentWidgets(this.drop, table);
        }
        if ((mainUrl = this.getOverviewPageUrl()) != null) {
            RedirectButton mainPageBut = new RedirectButton(this.page, "mainPageBut", "Main page", mainUrl);
            this.page.append((OgemaWidget)mainPageBut);
        }
    }

    public static void registerDependentWidgets(OgemaWidget governor, StaticTable table) {
        for (OgemaWidget el : table.getSubWidgets()) {
            governor.registerDependentWidget(el);
        }
    }
}

