/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.util.directresourcegui;

import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.object.widget.popup.ClosingPopup;
import de.iwes.widgets.resource.widget.table.ResourceTable;
import java.util.List;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.Resource;
import org.smartrplace.util.directobjectgui.ApplicationManagerMinimal;
import org.smartrplace.util.directobjectgui.ObjectResourceGUIHelper;
import org.smartrplace.util.directresourcegui.KnownWidgetHolder;
import org.smartrplace.util.directresourcegui.ResourceGUIHelper;
import org.smartrplace.util.directresourcegui.ResourceGUITableProvider;
import org.smartrplace.util.directresourcegui.ResourceGUITableTemplate;
import org.smartrplace.util.format.WidgetHelper;

public abstract class ResourceGUITablePage<T extends Resource>
implements ResourceGUITableProvider<T> {
    protected final WidgetPage<?> page;
    protected ResourceGUITableTemplate<T> mainTableRowTemplate;
    protected ResourceTable<T> mainTable;
    protected final boolean registerDependentWidgets;
    protected final ClosingPopup<T> popMore1;
    protected final KnownWidgetHolder<T> knownWidgets;
    protected final Alert alert;
    protected final Class<T> resourceType;
    protected final ApplicationManager appMan;
    protected final ApplicationManagerMinimal appManMin;
    protected long retardationOnGET = 0L;

    private String pid() {
        return WidgetHelper.getValidWidgetId(this.getClass().getName());
    }

    public abstract void addWidgetsAboveTable();

    public List<T> getResourcesInTable(OgemaHttpRequest req) {
        return this.appMan.getResourceAccess().getResources(this.resourceType);
    }

    public ResourceGUITablePage(WidgetPage<?> page, ApplicationManager appMan, Class<T> resourceType) {
        this(page, appMan, null, resourceType, true);
    }

    public ResourceGUITablePage(WidgetPage<?> page, ApplicationManager appMan, ApplicationManagerMinimal appManMin, Class<T> resourceType, boolean autoBuildPage) {
        this(page, appMan, appManMin, resourceType, autoBuildPage, true);
    }

    public ResourceGUITablePage(WidgetPage<?> page, ApplicationManager appMan, ApplicationManagerMinimal appManMin, Class<T> resourceType, boolean autoBuildPage, boolean registerDependentWidgets) {
        this.page = page;
        this.appMan = appMan;
        this.appManMin = appManMin;
        this.resourceType = resourceType;
        this.registerDependentWidgets = registerDependentWidgets;
        this.knownWidgets = new KnownWidgetHolder(page, "knownWidgets");
        page.append(this.knownWidgets);
        this.alert = new Alert(page, "alert", "");
        this.popMore1 = new ClosingPopup<T>(page, "popMore1", "More Information", true, ClosingPopup.ClosingMode.CLOSE){
            private static final long serialVersionUID = 1L;

            public void onGET(OgemaHttpRequest req) {
                Resource item = (Resource)this.getItem(req);
                if (item == null) {
                    return;
                }
            }
        };
        if (autoBuildPage) {
            this.triggerPageBuild();
        }
    }

    public void triggerPageBuild() {
        this.page.append(this.popMore1);
        this.mainTableRowTemplate = new ResourceGUITableTemplate<T>(new ResourceGUITableTemplate.TableProvider<T>(){

            @Override
            public ResourceTable<T> getTable(OgemaHttpRequest req) {
                return ResourceGUITablePage.this.mainTable;
            }
        }, this.resourceType, this.appMan, this.appManMin, this.registerDependentWidgets){

            @Override
            protected RowTemplate.Row addRow(T object, ResourceGUIHelper<T> vh, String id, OgemaHttpRequest req) {
                RowTemplate.Row row = new RowTemplate.Row();
                ResourceGUITablePage.this.addWidgets(object, vh, id, req, row, ResourceGUITablePage.this.appMan);
                return row;
            }
        };
        this.mainTable = new ResourceTable<T>((WidgetPage)this.page, "appTable" + this.pid(), (RowTemplate)this.mainTableRowTemplate){
            private static final long serialVersionUID = 1L;

            public void onGET(OgemaHttpRequest req) {
                List data = ResourceGUITablePage.this.getResourcesInTable(req);
                this.updateRows(data, req);
                if (ResourceGUITablePage.this.retardationOnGET > 0L) {
                    try {
                        Thread.sleep(ResourceGUITablePage.this.retardationOnGET);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.addWidgetsAboveTable();
        this.page.append((OgemaWidget)this.alert);
        this.page.append(this.mainTable);
    }

    public WidgetPage<?> getPage() {
        return this.page;
    }

    @Override
    public void addWidgets(T object, ObjectResourceGUIHelper<T, T> vh, String id, OgemaHttpRequest req, RowTemplate.Row row, ApplicationManager appMan) {
        this.addWidgets(object, (ResourceGUIHelper)vh, id, req, row, appMan);
    }

    @Override
    public T getResource(T object, OgemaHttpRequest req) {
        throw new IllegalStateException("getResource should not be used with ResourceGUITablePage");
    }

    public void triggerOnPost(OgemaWidget governor, OgemaWidget target) {
        if (this.registerDependentWidgets) {
            governor.registerDependentWidget(target);
        } else {
            governor.triggerAction(target, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST);
        }
    }
}

